UNIT FD_Circ;
{$I FD_INCL.PAS}
INTERFACE

USES FD_Def;


PROCEDURE fnCircuit ( pCB : tp_axcb; msg : T_Msg);
PROCEDURE Reconnected ( pCB : tp_axcb );

    CONST WITHVIA = TRUE;
          WITHOUTVIA = FALSE;
 FUNCTION DoAscConnect ( ifnr : t_ifnr; pCB:tp_axcb; sArg : STRING;
                         fWithVia, fMitText : BOOLEAN ) : BOOLEAN;
 FUNCTION DoDigiConnect (pCB:tp_axcb; pm:tp_mbuf ) : TP_AXCB;
PROCEDURE Pfoertner(pCB:TP_AXCB);

{}

IMPLEMENTATION

USES FD_Div,
     FD_Axcb,
     FD_Subr,
     FD_State,  {* LocalEvent *}
     FD_Main,
     FD_Info,
     FD_Timer,
     FD_Tx,
     {$IFDEF SCC} FD_TNC,
     {$ELSE}	  FD_CRT, DOS,
     {$ENDIF}
     FD_Mem,
     FD_AR;

{ Circuit }



PROCEDURE Reconnected ( pCB : tp_axcb);
BEGIN
  IF NOT CheckAXCB(pCB, cSTORE) THEN Exit;
{ IF pCB^.pInfoBox = NiL THEN Inc(backup.nReconnectError);}
  pCB^.QSOType := qtINFOBOX;
  pCB^.pPartnerCB := NiL;
  pCB^.fMsgHandler := fnMsgInfoBox;
  pCB^.tTimeOut.TickInit := 2 * longInt(InfoBoxTimeOut) DIV 3;
  pCB^.pInfoBox^.TimeOutStufe := ibtNULL;
  pCB^.pInfoBox^.fIntViaConnect := false;
  StartTimer (pCB^.tTimeOut);
  DoPrompt (pCB);
END;


{$F+}
PROCEDURE fnCircuit (pCB : tp_axcb; msg : T_Msg);
{* Handler fr Msg bei durchgeschalteten Verbindungen. Auf pCB^ ist *}
{* grad was angekommen, was an den Partner gesendet werden soll.    *}
  VAR s : STRING;
      pm : TP_mbuf;
BEGIN
  IF NOT CheckAXCB (pCB, cSTORE) THEN Exit;
  IF NOT CheckAXCB (pCB^.pPartnerCB, cCHECKONLY) THEN Exit;

  CASE msg OF
    msgRx : IF TxWindowUeberschritten(pCB^.pPartnerCB)
              THEN Event_BecomeBusy (pCB)
                   {* der Partner soll nun stille schweigen, da meine TXQ
                    * voll ist *}
              ELSE BEGIN {* Und hier die eigentlich Funktion eines Digis: *}
                   pm := pCB^.RxBuf;
                   pCB^.RxBuf := Nil;
                   pCB^.RxBufSize := 0;
                   pCB^.pPartnerCB^.pid := pCB^.pid; {* Wir machen alles mit ... *}
                   TXQueue_mBuf_chain (pCB^.pPartnerCB, SOFORT,pm ); {* umhngen RXQUEUE--> TXQUEUE *}
                   END;
{    msgReconnect, }
    msgDiscReq,
    msgRetryCountExceeded,
    msgRxDM
	  : BEGIN {* Verbindung trennen *}
	    pCB^.fMsgHandler := fnMsgDefault;
	    pCB^.pPartnerCB^.fMsgHandler := fnMsgDefault;
	    IF pCB^.QSOType = qtCIRCUITMASTER
	      THEN BEGIN {* HauptQSO is hin *}
                   {* IF msg<>discReq TX_INFO(partner,'*** DB0ME: LinkFailure .... *}
                   {* Bei einem DISC sollten dem Partner alle Pakete noch *}
                   {* zugestellt werden, die noch inner Queue sind *}
                   DoDisconnect (pCB^.pPartnerCB); {* Slave abschmeissen *}
                   END
	      ELSE IF pCB^.pPartnerCB^.pinfobox = Nil THEN DoDisconnectImm (pCB^.pPartnerCB)
	      ELSE BEGIN
		   IF msg = msgDiscReq THEN s := 'Disconnect received from'
				       ELSE s := 'Link failure with';
		   TX_EolSysInfo (pCB^.pPartnerCB, SPAETER,
		       {*** }axIFace[pCB^.pPartnerCB^.aktIfnr].asMyCall+': '+s+' '+f_sh2asc(pCB^.toCall)+EOL
                                   {* ^^^^^^^^^^Tescht! *}
{**                   +'*** reconnected to '       +axIFace[pCB^.pPartnerCB^.aktIfnr].asMyCall+EOL); *}
		      +'*** reconnected to '       +f_sh2Asc(pCB^.pPartnerCB^.fromCall)+EOL);
		   Reconnected (pCB^.pPartnerCB);
		   END;
	    pCB^.pPartnerCB := NiL;
	    END;
    ELSE fnMsgDefault ( pCB, msg );
  END;
END; {$IFNDEF AllFar} {$F-} {$ENDIF}


{ InfoBox }


PROCEDURE fnMsgConnectTry ( pCB : tp_axcb; msg : T_Msg );  FAR;
  {* pCB ist der Block, der vom Orginator erzeugt wurde *}
  VAR s : STRING;
BEGIN
 {* Sicher ist sicher - vielleicht ist der Veranlasser schon weg *}
  IF pCB^.pPartnerCB = NiL THEN
    IF (msg = msgConnectSuccess) OR (msg=msgReconnect) THEN
       BEGIN {* mhh... erst wenn ich verbunden bin, darf ich auch
              * wieder abschmeissen *}
       pCB^.fMsgHandler := fnMsgDefault;
       DoDisconnectImm(pCB);
       Exit;
       END;

  CASE msg OF
    msgConnectSuccess
      : WITH pCB^.pPartnerCB^ DO
	 BEGIN
	 pid := pCB^.pid; {* Na ja, nicht so doll *}
	 IF state = IGNORE
	    THEN GetDigiConnected (pCB^.pPartnerCB) {* ViaConnectVersuch *}
	    ELSE BEGIN {* kam aus der InfoBox *}
                 IF pCB^.pPartnerCB^.pInfoBox <> nil then
                   IF NOT pCB^.pPartnerCB^.pInfoBox^.fIntViaConnect THEN
                     TX_SysInfo (pCB^.pPartnerCB, SOFORT,'connected to '+f_sh2Asc(pCB^.tocall)+EOL);
		 StopTimer (tTimeOut);
		 END;
	 QSOType := qtCircuitMaster;
	 fMsgHandler := fnCircuit;
	 state := CONNECTED;
	 pCB^.QSOType := qtCircuitSlave;
	 pCB^.fMsgHandler := fnCircuit;
	 END;

   msgDiscReq,
   msgRxDM,
   msgCBDel,
   msgRetryCountExceeded
     : BEGIN
       pCB^.fMsgHandler := fnMsgDefault;
       IF pCB^.pPartnerCB <> NIL THEN
	 IF pCB^.pPartnerCB^.state <> IGNORE
	   THEN BEGIN {* Connect aus der Infobox kam nicht zustande *}
   	        IF pCB^.pPartnerCB^.state = CONNECTED THEN
                  BEGIN {* Diese Zusatzabfrage muss wohl sein, ansonsten *}
                  {* geschieht beim zuflligen "Verschwinden" (Kill,DM)  *}
                  {* des Hauptqsos Entsetzliches. Man braucht nur mal :K  *}
                  {* C bl0bb  (Kill 1) zu machen...                      *}
		  IF msg = msgRxDM THEN s := 'busy from '
		                   ELSE s := 'failure with ';
                  TX_SysInfo (pCB^.pPartnerCB, SPAETER, s+f_sh2asc(pCB^.tocall)+EOL);
		  Reconnected (pCB^.pPartnerCB);
                  END;
		END
	   ELSE BEGIN {* via kam nicht zustande, also das Partner QSO (das   *}
		      {* uns aufgefordert hatte) lschen. Kommt ein DM rein, *}
		      {* so kriegt bei L2-Digip. der Partner es nicht oder   *}
		      {* doch weitervermiitelt *}
		pCB^.pPartnerCB^.pPartnerCB := Nil ; {* Endlosschleife vermeiden *}
                Event_LocalStop (pCB^.pPartnerCB);
		END;
	{* lschen des auslsenden CB findet durch die Msg. sendende Proc. statt *}
       END;
  ELSE BEGIN
       fnMsgDefault ( pCB, msg );
       Exit; {* alles andere interessiert nicht *}
       END;
   END; {CASE}
END;  {$IFNDEF AllFar} {$F-} {$ENDIF}


FUNCTION DoDigiConnect (pCB:tp_axcb; pm:tp_mbuf ) : TP_AXCB;
  {* alle "via" Connect-Versuche werden hier bearbeitet *}
  {* AutoRouter wird immer benutzt                      *}
  VAR pNewCB : tp_axcb;
BEGIN
  DoDigiConnect := NiL;
  IF NOT TryToConnectRoute  (pm,pCB,pNewCB)
    THEN BEGIN
         DoDisconnect (pCB) {* pCB wird abgeworfen *}
         END
    ELSE BEGIN
         IF pNewCB <> NiL THEN
           BEGIN {* Hop2Hop aufbauen *}
  	   pNewCB^.pid := pCB^.pid;
	   pNewCB^.fMsgHandler := fnMsgConnectTry;
	   pNewCB^.qsoType := qtCircuitSlave;
	   pNewCB^.pPartnerCB := pCB;
	   pCB^.pPartnerCB := pNewCB;
	   pCB^.qsoType := qtCircuitMaster;
	   pCB^.state := IGNORE; {* weitere RXte SABM men ignoriert werden *}
           DoDigiConnect := pCB;
	   END;
         END;
END;


FUNCTION DoAscConnect ( ifnr : t_ifnr;
                        pCB  : tp_axcb;
                        sArg : STRING;
                        fWithVia,
                        fMitText : BOOLEAN ) : BOOLEAN;
  {* Mache einen Connectversuch zu *sArg* auf *IFNR*.            *}
  {* Kann auch von ausserhalb der Infobox angefordert werden!    *}
  {* Angefordert wurde er von pCB^. Ist sText nicht leer, so     *}
  {* wird dieser anstelle des Calls im Text-Linksetup ausgegeben *}
  LABEL l_EoP;
  VAR pNewCB : tp_axcb;
      intifnr  : Byte;
      t,v,info : STRING;
      shZ    : t_ShCall;
      shPath : T_ShPath;
BEGIN
  DoAscConnect := FALSE;
  IF pCB^.watchMode > 0 THEN
    IF (watch[pCB^.watchMode].typ AND bgNoExtConnect)<> 0 THEN
      BEGIN {* Er darf nicht Rausconnecten *}
      IF fMitText THEN TX_EolSysInfo (pCB, SOFORT, 'not now!');
      Exit;
      END;
  t := ''; v := ''; info := '';
  String2tv( sArg, t,v );
  IF NOT CheckCalls (pCB, v,t ) THEN GOTO l_EoP;

  String2shPath (sArg, shPath);

{$IFDEF asdasdas}
  IF v = '' THEN AscCall2shift ( t,  shZ )
            ELSE AscCall2shift ( v,  shZ );
  IF AR_SearchRoute ( shZ,FALSE, ifnr, v ) = 0 THEN;

  {* $TODO: Sehr provisorisch: *}
  IF useTheNet THEN
   IF useNETROMhint THEN
    IF (ifnr = 1) OR (ifnr > 4)  THEN {* offensichtlich kein Weg gefunden *}
      BEGIN {* Also Netrom befragen *}
      inrt := NR_SucheRoute ( t );
      IF inrt > 0 THEN
	BEGIN
	IF fMitText THEN Tx_EolSysInfo(pCB, SOFORT, 'can''t connect '+t+EOL+
		     +'*** pse connect '
		     +f_sh2Asc(NRTbl[inrt].nachbar)
		     +' first and try again' );
	GOTO l_EoP;
	END;
      END;

  {* Wenn interner Connect versucht wird, oder keine   *}
  {* Route bekannt, so wird der DefaultPort verwendet. *}
  IF (hw[ifNR].cDrv = drvLOOPBACK) OR
     (ifnr = IF_AUTOROUTER) THEN ifnr := axIFace[pCB^.iface].defaultUsrIfnr;

  Info := v;
  IF v <> '' THEN v := ',' + v;
  v := axIFace[ifnr].asMyCall+'*'+v ;

  pNewCB := TryToConnect ( ifnr,
			   f_sh2asc (pCB^.toCall),
                           t,
                           v);
{$ENDIF}

{* LinkLoopSuche, nicht optimal, da Connectversuch ja schon luft: *}
{*	 IF GetLinkFromCB(pNewCB) = GetLinkFromCB(pCB)	THEN     ***}
{$IFDEF dslkhkdf}
	 IF pCB^.iface = pNewCB^.iface THEN
	   IF axIFace[pNewCB^.iface].art = aINTERLINK THEN
             BEGIN
  	     sArg := sArg + EOL + '**** warning: linkloop detected'+BELL;
             {* if not sysop then exit *}
             END;
{$ENDIF}

  IF NOT SearchForPath (shPath, pCB, cCONNECT, Info, pNewCB)
    THEN BEGIN	{* Entweder outOfMem oder QSO exitiert schon *}
	 IF fMitText THEN TX_SysInfo (pCB,SOFORT, 'can''t connect twice'+EOL);
	 END
    ELSE BEGIN
         IF pNewCB <> NiL THEN
           BEGIN
	   pNewCB^.fMsgHandler := fnMsgConnectTry;
	   pNewCB^.qsoType := qtCircuitSlave;
	   pNewCB^.pPartnerCB := pCB;
	   pCB^.pPartnerCB := pNewCB;
	   pCB^.qsoType := qtCircuitMaster;
           DoAscConnect := TRUE; {* Nur hier kommt ein echter LinkSetup, auf den kein InfoBox prompt folgen darf *}
           END;
         sArg := EOL + '*** link setup... to '+t;
         IF fWithVia THEN IF Info <> '' THEN sArg := sArg + ' via '+info;
         IF fMitText THEN TX_Info (pCB,SOFORT, sArg+EOL);
	 END;
l_eop:
END;

{}


PROCEDURE Pfoertner(pCB:TP_AXCB);
  VAR pNewCB : TP_AXCB;
BEGIN
  pNewCB := Try2Connect ( PfoertPort,
                          sPfoertFm ,
                          sPfoertTo,
                          sPfoertVia, cNOINCSSID );
  IF pNewCB <> Nil THEN
    BEGIN
    pNewCB^.who := auto;
    pNewCB^.fMsgHandler := fnMsgConnectTry;
    pNewCB^.qsoType := qtCircuitSlave;
    pNewCB^.pPartnerCB := pCB;
    pCB^.pPartnerCB := pNewCB;
    pCB^.qsoType := qtCircuitMaster;
    END;

END;


END.
