{$I FD_INCL.PAS}
UNIT FD_Beacon;   {* Routinen fr Baken und Stationensuche *}

INTERFACE

USES FD_Def;

  CONST maxBeacon = 10;
        nBeacon : BYTE = 0;
  CONST cBCSTRING='##BC##';

  TYPE TP_Beacon = ^T_Beacon;
       T_Beacon = RECORD
                    f,t,v,
                    Infostr : string;
                    ifnr    : T_IfNr;
                    minInterval,  {* Aussendeintervall *}
                    minutenTick : Integer; {* soviele Minuten sind es noch bis zur nchsten Messung *}
                   END;


  VAR Beacon : ARRAY [1..maxBeacon] OF tp_Beacon;


PROCEDURE DoBeacon ( pUCB : TP_AXCB; sArg : STRING);

PROCEDURE TxBeacon ( ifnr : t_ifNR; CONST f,t,v,infostr : String; kmpf : T_kmpf);
{PROCEDURE TxBeacon ( ifnr : t_ifNR; f,t,v,infostr : String; kmpf : T_kmpf);}
PROCEDURE TxCTRL (  frameTyp  : T_FrameTyp; ifnr : t_ifNR; f,t,v : STRING;  kmpf : T_kmpf);
 FUNCTION MakeBeacon ( ifnrp:t_ifNR; intervall:WORD; fp,tp,vp,sInfoStrP:String ) : WORD;
 FUNCTION GetSysInfo4Beacon (ifnr : t_ifnr ) : STRING;

PROCEDURE DoFind (pUCB : tp_axcb; s : String );
 FUNCTION DMfinalReceived (pm : tp_mBuf;  pCB : tp_axcb) : BOOLEAN;
PROCEDURE UICQReceived(pm:tp_mbuf);

PROCEDURE Manuell_FastDigiSearch (ifnr : t_ifNR; f,t,v : String );
PROCEDURE DoEveryMinuteBeacon;

{}

IMPLEMENTATION


USES FD_mem,
     fd_axcb,
     fd_tx,
     fd_div,
     fd_timer,   {* wg. Anzeige nGlobalTimer_fast *}
     FD_AX,      {* wg. AX-Variable *}
     fd_subr,
     fd_ar,      {* fr Laufzeitmessungen - KONSTANTEN ! *}
     fd_sysop,   {* wg. GetRemoteStatus *}
     fd_link ,   {* wg. GetLinkInfo4Beacon *}
     fd_main     {* wg. DefaultMsgHandler *}
     ;

{}

FUNCTION GetSysInfo4Beacon (ifnr : t_ifnr) : STRING;
  VAR minuten : LongInt;
      s : STRING;
      i : WORD;
      p : Pointer;
BEGIN
 minuten := fastTick DIV _Sekunden DIV 60;
 s :=
   pgmVersion + '  '+
   axIFace[ifnr].asMyIdent+':' + axIFace[ifnr].asMyCall
   + EOL +
            fStr ( minuten DIV (24*60))
     + '.'+ fStr ((minuten DIV 60) MOD 24)
     + ':'+ FStr    ( minuten MOD 60 ) + '"'+
   ' nRst:' + FStr(backup.nReset)+
   ' nErr:' + FStr(backup.nError)+
   ' RTE'    + FStr(backup.err[1].Code) +
   ' at '   + HexAddrString(Backup.Err[1].Adr) +
   ' '      + FStr(backup.err[1].Zeit.hour)+
   ':'      + FStr(backup.err[1].Zeit.min) +

   EOL      +
   'Mem:'   + fStr (sysMemAvail) +
        '/' + fStr (sysMaxAvail) +
        '/' + fStr (everSysMinMaxAvail)+
   ' AXCB:'  + FStr (nAXCBAnzahl) + '/'
             + FStr (MaxAssignedCBId) +
   EOL+
    'mF:' + FStr(nAllocFreeBuffer)+'/'
          + FStr(nFreeBuffer) + '/'
          + FStr(nMinFreeBuffer) +
   ' nSt:'   + FStr (backup.nStackStore) +
   ' IntTbl:'+ fStr(backup.IntTableChged) +
   ' Sem:'   + fStr(backup.semem) +
   ' StdBy:' + FStr(ord(StandByStartUp));

 {$IFDEF brauchen_wir_nicht_mehr}
  p := @showmemdebug;
  FOR i := 1 TO SizeOf (showmemdebug) do
    BEGIN
    s:= s+hexbyteString( byte(p^));
    Inc(word(p));
    END;
 {$ENDIF}
 GetSysInfo4Beacon := s+EOL;
END;



{}

PROCEDURE TxBeacon ( ifnr : t_ifNR; CONST f,t,v,infostr : String; kmpf : T_kmpf);
  {* Einmaliges Ausstrahlen einer Bake *}
  VAR pCB : tp_axcb;
      i   : WORD;
      s,sOut   : String;
BEGIN
  pCB := CreateAXCB (ifnr);
  IF pCB <> NiL THEN
    BEGIN
    Asc2axcb ( f,t,v, pCB );
    IF      infostr = '##INFO##'   THEN s := GetSysInfo4Beacon (ifnr)
    ELSE IF infostr = '##LINK##'   THEN s := GetLinkInfo4Beacon
    ELSE IF infostr = '##REMOTE##' THEN s := GetRemoteStatus
    ELSE IF infostr = '##CTEXT##'  THEN s := sCText
    ELSE                                s := infoStr;
    CvMacro(pCB,s,sOut);
    {* $OPT Autorouter ! *}
    pCB^.QSOType := qtBAKE;
    pCB^.iFace := ifnr;
    pCB^.pf := cMELD;
    Tx_UInfo ( pCB,  kmpf, sOut );
    Del_axcb ( pCB );
    END;
END;



PROCEDURE TxCTRL ( frameTyp  : T_FrameTyp; ifnr : t_ifNR; f,t,v : STRING;  kmpf : T_kmpf);
  {* Einmaliges Ausstrahlen eines controlframes *}
  VAR pCB : tp_axcb;
      b   : BYTE;
BEGIN
  pCB := CreateAXCB (ifnr);
  IF pCB <> NiL THEN
    BEGIN
    Asc2axcb ( f,t,v, pCB );
    pCB^.QSOType := qtBAKE;
    pCB^.iFace := ifnr;
    pCB^.pf := cPOLL;
  CASE frameTyp OF   {* $OPT*: Konstante Tabelle: x : ARRAY [RR..FRMR] OF BYTE;*}
     RR    :  b := $01;
     RNR   :  b := $05;
     REJ   :  b := $09;
     SABM  :  b := $2f;
     DISC  :  b := $43;
     UA    :  b := $63;
     DM    :  b := $0f;
     FRMR  :  b := $87;
     INFO  :  b := $00;
     END;
    IF (kmpf AND cPFBIT) <> 0 THEN b := B OR $10;
    IF (kmpf AND cKOMM)  <> 0 THEN TX_Ctl ( pCB, cKOM, b )
                              ELSE TX_Ctl ( pCB, cMEL, b );
    Del_axcb ( pCB );
    END;
END;


PROCEDURE DoEveryMinuteBeacon;
{* Ein globaler Minuten Timer. Nach Auslaufen werden alle Eintrge berprft, *}
{* ob sie fllig sind. Wenn ja, aussenden und aktMinuten neu setzen, sonst    *}
{* aktMinuten runterzhlen.                                                   *}
  VAR i : WORD;
BEGIN
  FOR i := 1 TO maxBeacon DO IF Beacon [i] <> Nil THEN WITH beacon [i]^ DO
   IF infostr<>cBCSTRING THEN
    BEGIN
    Dec (minutenTick);
    IF minutenTick <= 0 THEN
      BEGIN
      TxBeacon (ifnr,f,t,v,infostr,cMELD);
      minutenTick := minInterval;
      END;
    END;
END;

{}


FUNCTION MakeBeacon ( ifnrp:t_ifNR; intervall:WORD; fp,tp,vp,sInfoStrP:String ) : WORD;
  VAR pCB : TP_AXCB;
        i : BYTE;
BEGIN
  MakeBeacon := 0;
  i := 1;
  WHILE (i <= MaxBeacon) AND (Beacon[i]<> NiL) DO Inc (i);
  IF i > MaxBeacon THEN Exit; {* kein Platz mehr *}

  MemGet ( Pointer(beacon[i]), SizeOf(Beacon[i]^) );

  WITH BEACON [i]^ DO
    BEGIN
    ifnr := ifnrp;
    f := fp;
    t := tp;
    v := f_Upper(vp);
    infostr := sinfostrp;
    IF intervall < 60 then intervall := 60;
    minInterval := Intervall DIV 60;
    minutenTick := 3; {* Erste Mal nach drei Minuten senden *}
    END;

  Inc (nBeacon);
  MakeBeacon := i;
END;


PROCEDURE ChangeBeacon ( nr : WORD; ifnr : WORD; intervall : WORD; infostr : String );
BEGIN
  IF Beacon[nr] = NiL THEN Exit;

  if infostr <> '' THEN beacon[nr]^.infostr := infostr;
  IF ifnr <> NOTANUMBER THEN beacon[nr]^.iFnr := ifnr;

  IF interVall <> 0 THEN
    BEGIN
    IF intervall < 60 then intervall := 60;
    beacon[nr]^.minInterval := Intervall DIV 60;
    beacon[nr]^.minutenTick := 1; {* Direkt nach einer Minute senden *}
    END;
END;


FUNCTION DelBeacon ( nr : BYTE ) : BOOLEAN;
BEGIN
  DelBeacon := FALSE;
  IF Beacon[Nr] = NiL THEN Exit;

  MemFree ( Pointer(Beacon[nr]), SizeOf (Beacon [nr]^) );
  Beacon[Nr] := NiL;
  Dec (nBeacon);
  DelBeacon := TRUE;
END;


PROCEDURE DoBeacon ( pUCB : TP_AXCB; sArg : STRING);
{*  BEACON [ADD|INS|DEL|CHANGE] [NR <wert>] [PORT <wert>] [MINUTEN <wert>] [ZIEL <Ziel> [VIA <pfad> ]] text *}
 CONST	COMANDS =
 'ADD INS DEL PORT MINUTEN ZIEL VIA SEND NR CHANGE ROUT '; {* Letzte Leerzeichen ist wichtig ! *}
     cmdTab : ARRAY [1..length(COMANDS)] OF CHAR = COMANDS;
  VAR i : BYTE;
      BakenNr,
      PortNr,
      Minuten : WORD;
      modus   : (list,chg,ins,del,send);
      sErg,
      sText,
      viaCall,
      zielCall : STRING;
BEGIN
  modus := LIST; {* Default *}
  IF (sArg <> '') AND (pUCB^.who=SysOp) THEN
    BEGIN
    PortNr := NOTANUMBER;
    BakenNr := NOTANUMBER;
    minuten := 10;
    zielCall := 'BAKE'; viaCall := '';
    sText := axIFace[1].asMyCALL + ' & '+pgmVersion;
    REPEAT
      i := ScanStr (sArg, @cmdTab, sizeOf (cmdTab));
      CASE i OF
         1,2: modus := ins; {* INS *}
         3: modus := del; {* DEL *}
         4: portnr := ScanForNum ( sArg );
         5: minuten := ScanForNum ( sArg );
         6: ScanForText ( sArg, zielCall );
         7: ScanForText ( sArg, viaCall );
         8: modus := SEND;
         9: BakenNr := ScanForNum ( sArg );
        10: modus := CHG;
        11: RoutBeaconPort := ScanForVal ( sArg );
        END;
    UNTIL i = 0;

    IF sArg <> '' THEN ScanForText (sArg,sText);
    sErg := '';

    IF (modus = CHG) THEN
      IF (bakenNr = NOTANUMBER) OR (beacon[bakenNr] = NiL)
        THEN TX_EolSysInfo (pUCB, SPAETER, 'BEACON CHG: wrong number' )
        ELSE BEGIN
             IF minuten = NOTANUMBER THEN minuten := 0;
             ChangeBeacon ( BakenNr, PortNr,60*minuten, sText );
             END;

    IF (modus = INS) THEN
      BEGIN
      IF  (portNr <> NOTANUMBER) AND
          (minuten <> NOTANUMBER) AND
          (minuten <> 0) AND
          (zielCall <> '' )
        THEN IF MakeBeacon ( portnr, 60*minuten, axIFace[portnr].asMyCall, ZielCall, viaCall, sText ) <> 0
                THEN sErg := 'BEACON installed'
                ELSE sErg := 'can''t install beacon'
        ELSE sErg := 'ADD: wrong Parameter';
      END;

    IF (modus = DEL) THEN
      BEGIN
      IF (BakenNr <> NOTANUMBER) AND (beacon[bakenNr] <> NiL)
         THEN IF DelBeacon (BakenNr)
                THEN sErg := 'OK'
                ELSE sErg := 'can''t delete this beacon'
         ELSE sErg := 'DEL: wrong Parameter' ;
      END;

    IF (modus = SEND) THEN
      IF (BakenNr <> NOTANUMBER) AND (beacon[bakenNr] <> NiL)
         THEN BEGIN
              WITH beacon[bakenNr]^ DO TxBeacon (ifnr,f,t,v,infostr,cMELD);
              sErg := 'ok';
              END
         ELSE sErg := 'SEND: wrong Parameter';

    IF sErg <> '' THEN TX_EolSysInfo (pUCB, SPAETER, sErg );
    END;

  IF (modus = LIST) THEN
    BEGIN  {* nur Auflisten *}
    Tx_Info(pUCB, SPAETER, EOL+ Fstr(RoutBeaconPort) );
    FOR i := 1 TO maxBeacon DO IF beacon[i] <> NiL THEN WITH beacon[i]^ DO
      BEGIN
      Tx_Info(pUCB, SPAETER, EOL
        + FStr(i)+'. P'
        + FStr(ifnr)+
        + f_Using(minInterval,3)+' Min. ('
        + f_Using(minutenTick,3)+') '
        + t +' '+v
        + ' "'+InfoStr+'"' );
      END;
    END;
END;


{ FIND }

{* Prinzip:
 *
 * Jeder FIND Befehl hat einen Auslser-pCB. Fr jeden in der
 * Search/Link-Tabelle vorgegebenen Ziele wird FINDRETRY * SEARCH-Paket
 * (UI mit Poll) abgeschickt.
 * Ein DM mit gesetztem FINAL an uns wird in der State Tabelle (Unknown QSO)
 * gesondert behandelt: Es wird getestet ob das ZielCall im Digi ist. Wenn ja
 * wird ihm die entsprechende .
 *}


PROCEDURE DoFind (pUCB : tp_axcb; s : String );
 {* startet die Suche durch, die aus der Verbindung pCB^
  * heraus verlangt wurde *}
  LABEL l_eop;
  VAR pFCB : tp_axcb;
      i,j      : WORD;
      ifnr   : t_ifnr;
      atLeastOne : BOOLEAN;
      shZ    : t_ShCall;
      t,v    : STRING;
      sErg   : STRING;
BEGIN
  {* Abfrage auf Disabled bereits in FD_INFO passiert! *}
  sErg := 'invalid Callsign';
  IF s = '' THEN GOTO l_eop;

  String2tv (s, t,v);
  IF dnCallCheck THEN
    BEGIN
    IF NOT ValidCall(t) THEN GOTO l_eop;
    IF v <> '' THEN
      IF NOT ValidVia(v) THEN
        BEGIN
        sErg := 'invalid via-path';
        GOTO l_eop;
        END;
    END;
  sErg := '';

  SucheCallInDigi ( s, scmJeder, pFCB);
  IF pFCB <> NiL THEN
    BEGIN
    sErg := f_sh2asc(pFCB^.toCall) + ' is using this digi';
    GOTO l_eop;
    END;

  pFCB := CreateAXCB (1); {* irgendein Interface *}
  IF pFCB = NiL THEN
    BEGIN
    sErg := 'can''t search';
    GOTO l_eop;
    END;

  sErg := 'searching '+t;
  FOR j := 1 TO FindRetry DO
    BEGIN {* zunchst auf allen Einstiegen *}
    FOR i := 1 TO MAX_IFACE DO WITH axIFace[i] DO
      IF axiface[i].valid THEN IF art=aUser THEN
        BEGIN
        pFCB^.state := DISCONNECTED;
        pFCB^.iFace := i;
        v := axIFace[i].AsMyCall+'-'+FStr(FindSSID) + '*';
        Asc2axcb ( f_sh2Asc(pUCB^.toCall), t,v, pFCB );  {* Setzt u.a. EoA und nDigi *}
        Tx_UInfo ( pFCB, cPOLL, pgmName+'-Search'+EOL );
        END;
    FOR i := 1 TO nLinks DO WITH Link[i] DO
      IF valid AND NOT Hidden AND (system<>dsTCPIP) AND (NOT direkt) THEN
        BEGIN
        pFCB^.state := DISCONNECTED;
        ifnr := LinkPort2IfNr(i);
        pFCB^.iFace := ifnr;
        v := axIFace[ifnr].AsMyCall+'-'+FStr(FindSSID) + '*,'+ LinkPort2Via(i,cNORMAL);
        IF NOT direkt THEN
          BEGIN
          IF v[length(v)] <> ',' THEN v := v + ',';
          v := v +f_sh2Asc(call);
          END;
        Asc2axcb ( f_sh2Asc(pUCB^.toCall), t,v, pFCB );
        Tx_UInfo ( pFCB, cPOLL, pgmName+'-Search'+EOL );
        END;
    END;

  Del_axcb ( pFCB );
l_eop:
  TX_EolSysInfo (pUCB,SPAETER,sErg);
END;


FUNCTION DMfinalReceived (pm : tp_mBuf;  pCB : tp_axcb) : BOOLEAN;
 {* wird von FD_State aufgerufen, wenn ein DM- eintrifft, der keinem  *}
 {* bestehenden QSO zugeordnet werden konnte. Wenn es wirklich eine FIND-  *}
 {* Antwort war, wird TRUE zurckgegeben *}
  VAR pToCB : TP_AXCB;
BEGIN
  DMfinalReceived := FALSE;
  IF (pCB^.nDigi > 0) AND {* Das ist bei FIND immer so *}
     (pCB^.nMyCall > 0) THEN {* wahrscheinlich redunant *}
    IF   f_sh2Asc(pCB^.Digi[pCB^.nMyCall])
       = axIFace[pCB^.iface].AsMyCall+'-'+FStr(FindSSID) THEN {* Sonst ist es keine Antwort auf FIND *}
      BEGIN
      SucheCallinDigi ( f_sh2Asc(pCB^.fromCall), scmFREIER, pToCB );
      IF pToCB <> NiL THEN
        BEGIN
        TX_EolSysInfo (pToCB, SOFORT, f_sh2Asc(pCB^.toCall) + ' found via '+f_digi2str(pCB,1)+EOL );
        DMfinalReceived := TRUE;
        END;
      END;
END;

    CONST stLastUICQBeacon : Longint = -10000; {* Damit's beim Start schon geht *}
PROCEDURE UICQReceived(pm:tp_mbuf);
 {* kw 5.12.98 *}
  VAR iface : WORD;
BEGIN
  iface := pm^.ifnr;

  {* Nur auf Einstiegen *}
  IF axIFace[iface].art <> aUser THEN Exit;

  {* Maximal alle halbe Minute die Bake *}
  IF slowTick-stLastUICQBeacon < 60 THEN Exit;
  stLastUICQBeacon := slowTick;

  TxBeacon ( iface, axIFace[iface].asMyCall,'INFO','', '##CTEXT##', cMELD);
END;

{}

PROCEDURE Manuell_FastDigiSearch ( ifnr : t_ifNR; f,t,v : String );
  VAR pCB : tp_axcb;
BEGIN
  pCB := CreateAxcb (ifnr);
  IF pCB <> NiL THEN BEGIN
                     Asc2axcb ( f,t,v, pCB );
                     pCB^.iFace := ifnr;
                     pCB^.pf := cPOLL;
                     tx_UInfo ( pCB, cPOLL, pgmName+'-Search' );
                     Del_axcb ( pCB );
                     END;
END;

{}

BEGIN
  FillChar ( Beacon, sizeof(Beacon), #0 );
END.

