UNIT FD_BC;
{$I FD_INCL.PAS}

INTERFACE

{$IFNDEF scc} {$O+,F+}  {$ENDIF}

USES fd_def;

PROCEDURE FnBCHandler ( pCB : tp_axcb;  msg : T_Msg ); {$IFNDEF AllFar} {$F-} {$ENDIF}

{}

IMPLEMENTATION

 USES fd_state,
      FD_Beacon,
      fd_tx,
      FD_CRC,
      FD_Main,
      fd_subr,
      FD_SysOp, {wg. TraceInfo}
      fd_div,
      fd_mem,
      {$IFDEF SCC} fd_tnc
      {$ELSE}      fd_crt
      {$ENDIF}
      ;
             {* Und nun den PACSAT-FileHeader erzeugen:
                <000>   Id           aa 55
                                    <ID> <len>
            +   <002>   filenumber:  01 00 04 .. .. .. .. (curHeader.id)
            -   <009>   fileName:    02 00 08 .. .. .. .. .. .. .. .. (curHeader.id asString or sCurSBLine fill with Space)
            -   <021>   fileExt :    03 00 03 .. .. .. ('BID')
            +   <027>   fileSize     04 00 04 .. .. .. .. (longint> tja.....inkl. PFHeader)
            -   <035>   creatTime    05 00 04 .. .. .. .. (longint unixtime)
            -   <042>   lastmodTime  06 00 04 .. .. .. .. (longint unixtime)
            -   <049>   seuFlag      07 00 01 00 (Filezustand)
            -   <053>   filetype     08 00 01 00 (= ASCII)
            -   <057>   bodychksum   09 00 02 .. .. (adding all bytes)
            -   <062>   headerChkSum 0a 00 02 .. ..
            +   <067>   body offset  0b 00 02 .. ..  (75 dec)

              extended
                     +  Source        0x10 00 xx <ascii 7bit>   headerzeile-absender (nach "<")
                     -  uploader      0x11 00 06 <ascii-call>  rightpadded spaces
                     -  uploadtime    0x12 00 04 <unixtime>    wann war upload completed
                     -  download_count0x13 00 01 <unsigned char>
                      - destination   0x14 00 xx <ascii 7bit>   rubrik?
                      - ax25_downloade0x15 00 06
                      - downloadtime  0x16 00 04 <unixtime>
                      + expieretime   0x17 00 04 <unixtime>    Lifetime nach #
                      - priority      0x18 00 01 <byte>

              optional
                      - compression   0x19 00 01  <byte>
                      - bbs_message_type 0x20 00 01 <byte>
                      + bid              0x21 00 xx <ascii>
                      + title            0x22 00 xx <ascii>   (2.Zeile)
                      + keywords         0x23 00 xx    "      rubrik,Verteiler
                      - file_description 0x24 00 xx    "
                      - compress_  "     0x25 00 xx    "
                      - user_file_name   0x26 00 xx    "

                 -End Header   00 00 00
                 <data>
             *}

{}

CONST zBcState : (cNULL,
                  cWaitIniString,
                  cWaitHeader,
                  cWaitData
                  ) = cNULL;
TYPE T_BCHeader = RECORD
                    flags : BYTE; { $20:LastBit  $02:ByteOffset   $01:LengthField_presnt }
                    id : longint;
                    typ : BYTE;
                    offset : WORD;
                    offsetH : BYTE;
                    {extended: len:word}
                  END;
     T_BCTail   = RECORD
                    crc : WORD;
                  END;
     T_BCPaket  = RECORD
                    head : T_BCHeader;
                    data : ARRAY[1..257-sizeof(t_BCHeader)-sizeof(t_bcTail)] OF BYTE;
                    tail : T_BCTail;
                  END;

{* Tausend bunte globale Variable, alles ziemlich grausam... *}

TYPE T_BCQSO = RECORD
       header : t_BcHeader;
       curFileSize : Longint;
       crcBody,
       lenFHeader : WORD;
       sSBLine,
       sTitle,
       sBID,
       sAbsender,
       sVerteiler,
       sRubrik : String;
       END;

VAR bc : T_BCQSO;


{$IFDEF BroadCast}

PROCEDURE DoBcSend(pData : Pointer; size : Integer; fLast : BOOLEAN);
  CONST cMAXSIZE=240;
  VAR buf : Array [1..256] OF Char;
      txSize,i,j,
      wZwisp,framesize : WORD;
BEGIN
  IF (size<1) AND NOT fLast THEN Exit; {* bei flast darf leer sein! *}
  REPEAT
    IF size > cMAXSIZE THEN txsize := cMAXSIZE
                       ELSE txsize := size;
    size := size-txSize;
    MOVE( pData^, Buf[sizeof(bc.Header)+1], txsize);
    Inc(Word(pData),txSize);
    {* Last Flag setzen wenn das der letzte Teil *}
    IF fLast and (size=0) THEN OrSelf (bc.Header.flags, $20 )
                          ELSE AndSelf(bc.Header.flags, $df );
    { offsetH := 0; }
    frameSize := sizeof(bc.Header)+txsize+2; {* Incl CRC *}
    Move( bc.Header, buf[1], sizeof(bc.Header));
    wZwisp := Calc_CRCFBB( $0, @buf, frameSize-2 );
    {* CRC ist im HiLo-Format, offenbar wird die CRC nicht als 16bit-Wort sondern als 2 Byte betrachtet! }
    buf[ frameSize - 1 ] := char(hi(wZwisp));
    buf[ frameSize     ] := char(lo(wZwisp));

    FOR i := 1 TO maxBeacon DO IF Beacon [i] <> Nil THEN With beacon [i]^ DO
      For j := 1 TO minInterval DO
        IF infostr=cBCSTRING THEN
          BEGIN
  {$r-}   Inc(nBCUI);
          TxUi ( @buf,  frameSize,
                 ifnr,
                 f_sh2Asc(BcShBoxCall),'QST-1',
                 f_sh2Asc(axiface[ifnr].Call)+'*'+v,
                 cMELD,  PID_BC);
          END;

    Inc(bc.header.offset, txsize);
  UNTIL size=0;
END;


PROCEDURE SFHeaderZerlegen(s:string);
 {* z.B: S IBM @ WEST < DJ5KS $04a403db0mka #100 *}
 {* z.B: SB IBM @ WEST < DJ5KS $04a403db0mka #100 *}
  VAR n : WORD;
BEGIN
  bc.sBID:=''; bc.sAbsender:=''; bc.sVerteiler:=''; bc.sRubrik:='';

 n := Pos('S ',s);
 IF n = 0 THEN
   BEGIN
   n := Pos('SB ',s);
   IF n = 0 THEN Exit;
   END;
 IF n>1 THEN Exit;
 Delete(s,1,n+1);
 ScanForText(s,bc.sRUBRIK);

 n := Pos('@ ',s);
 IF n > 0 THEN BEGIN
               Delete(s,1,n+1);
               ScanForText(s,bc.sVerteiler);
               END;

 n := Pos('< ',s);
 IF n > 0 THEN BEGIN
               Delete(s,1,n+1);
               ScanForText(s,bc.sAbsender);
               END;

 n := Pos('$',s);
 IF n > 0 THEN BEGIN
               Delete(s,1,n);
               ScanForText(s,bc.sBID);
               END;
END;

PROCEDURE MakeBCFileHeader( fOnlyCalc : BOOLEAN );
{- Berechnet Grsse der FileHeaders, und schreibt ihn sofern fOnlyCalc=FALSE
 - ist, in einen Speicherbereich, der dann gesendet wird. Ein wenig heftig
 - konstruiert, dafr aber robust... (hoffentlich)
 -}
 Var HeaderSize : WORD;
   PROCEDURE HeaderFill(Var pZiel : Pointer; id:WORD;  pData:POINTER; len:BYTE);
   {- Headerteil besteht aus ID,Len und Daten -}
   BEGIN
     Inc(HeaderSize,3+len);
     IF fOnlyCalc THEN Exit;
     Word(pZiel^):=id;           Inc(word(pZiel),2);
     Byte(pZiel^):=len;          Inc(word(pZiel));
     Move(pData^, pZiel^, len);  Inc(word(pZiel),len);
   END;
 Var p : POINTER;
      pHeaderSum,
      pFHeader : POINTER;
      now : Longint;
      crc,
      ic : WORD;
BEGIN
{  $aa $55
   $01 $00 $04 (Header.id)
    $02 $00 $08 (Filename )
    $03 $00 $03 (FileExt)
            -   <035>   creatTime    05 00 04 .. .. .. .. (longint unixtime)
            -   <042>   lastmodTime  06 00 04 .. .. .. .. (longint unixtime)
            -   <049>   seuFlag      07 00 01 00 (Filezustand)
            -   <053>   filetype     08 00 01 00 (= ASCII)
            -   <057>   bodychksum   09 00 02 .. .. (adding all bytes)
   $04 $00 $04 .. .. .. .. (header.filesize longint>
   $0b $00 $02 .. ..  (header.bodyoffset/headersize)
   $10 $00  xx <ascii 7bit>   headerzeile-absender (nach "<")
   $14 $00  xx <ascii 7bit>   rubrik?
   $21 $00  xx <ascii>  BID
   $22 $00  xx <ascii>   title
   $23 $00  xx    "      Verteiler
   $00 $00 $00  }
   now:=UnixZeitNow;
   IF NOT fOnlyCalc THEN
     BEGIN
     MemGet(pFHeader, bc.LenFHeader );
     FillChar(pFHeader^, bc.LenFHeader, '!' );
     p := pfHeader;
     Word(p^) := $55AA; Inc(word(p),2);
     END;
   HeaderSize := 2;
   HeaderFill( p, $01, @bc.Header.id, sizeof(bc.Header.id) );
   HeaderFill( p, $02, @bc.sBID[1], 8 );
   HeaderFill( p, $03, @bc.sBID[1], 3 );
   HeaderFill( p, $04, @bc.curFileSize, sizeof(bc.curFileSize) );
   HeaderFill( p, $05, @now, sizeof(now) );   {createTime}
   HeaderFill( p, $06, @now, sizeof(now) );   {modTime}
   HeaderFill( p, $07, @byte0, sizeof(byte0) );   {seuFlag}
   HeaderFill( p, $08, @byte0, sizeof(byte0) );   {Filetype}

   HeaderFill( p, $09, @bc.crcBody, sizeof(bc.crcBody) );   {BodyChksum}
   pHeaderSum := p; {Zwischenspeichern....}
   HeaderFill( p, $0a, @word0, sizeof(word0) );   {HEaderChksum}
   HeaderFill( p, $0b, @bc.LenFHeader , sizeof(bc.LenFHeader) );   {Bodyoffset}

   HeaderFill( p, $10, @bc.sAbsender[1] , length(bc.sAbsender)  );   {source}
   HeaderFill( p, $11, @sSpace[1] , 6  );   {uploader}
   HeaderFill( p, $12, @now , sizeof(now)  );   {upload-time}
   HeaderFill( p, $13, @byte0, sizeof(byte0) );   {downloadCount}
   HeaderFill( p, $14, @bc.sRubrik[1] , length(bc.sRubrik)  );   {destination}
   HeaderFill( p, $15, @sSpace[1] , 6  );   {ax25-downloader}
   HeaderFill( p, $16, @now , sizeof(now)  );   {download-time}
   HeaderFill( p, $17, @longint0, sizeof(longint0)  );   {expire-time}
   HeaderFill( p, $18, @byte0, sizeof(byte0)  );   {priority}

   HeaderFill( p, $19, @byte0, sizeof(byte0)  );   {compression}
   HeaderFill( p, $20, @byte0, sizeof(byte0)  );   {bbs_message_type}
   HeaderFill( p, $21, @bc.sBID   [1] , length(bc.sBid   )  );   {bid}
   HeaderFill( p, $22, @bc.sTitle [1] , length(bc.sTitle )  );   {title}
   HeaderFill( p, $23, @bc.sVerteiler[1] , length(bc.sVerteiler )  );   {keywords}
   HeaderFill( p, $24, @bc.sSBLine[1] , length(bc.sSBLine )  );   {file_description}
   {25+26: ertmal uninteressant}
   Inc(HeaderSize,3); {fr EndofData}
   IF NOT fOnlyCalc THEN
     BEGIN
     Word(p^):=$0000;  Inc(word(p),2); Byte(p^):=0;  {End of Header}
     {Berechne und ausfllen von Header-Checksumme}
     p := pFHeader;
     FOR ic := 1 TO HeaderSize DO
       BEGIN
       crc := (longint(crc) + byte(p^)) AND 65535;
       Inc(Word(p));
       END;
     HeaderFill( pHeaderSum, $0a, @crc, sizeof(crc) );   {HEaderChksum}
     bc.Header.offset := 0;
     DoBcSend(pFHeader, bc.LenFHeader, True{Last-Flag!} );
     MemFree(pFHeader, bc.LenFHeader);
     END;
   bc.LenFHeader := HeaderSize;
END;
{$ENDIF}

{$F+}PROCEDURE FnBCHandler ( pCB : tp_axcb;  msg : T_Msg ); {$IFNDEF AllFar} {$F-} {$ENDIF}
  VAR bctxBuff : Array [1..242] OF Char;
      fLastPacket : BOOLEAN;
      info, s : STRING;
      ic,
      dataSize : WORD;
BEGIN
{$IFDEF BroadCast}

IF BcPort = 0 THEN
  BEGIN
  DoDisconnectImm(pCB);
  Exit;
  END;

CASE msg OF
  msgConnectSuccess  {* Wird auch verwendet, wenn ein Connect von aussen selber kommt. *}
    : BEGIN
      zBcState := cWaitIniString;
      Tx_INFOOneFrame(pCB,SOFORT,'[DigiWareBC $]'+EOL); {* ich bin ne Box *}
      Tx_INFOOneFrame(pCB,SOFORT,'>'+EOL);              {* dto. *}
      END;

  msgRX
    : BEGIN
      IF      pCB^.RxBufSize > 3000 THEN Event_BecomeBusy(pCB)
      ELSE IF pCB^.rxbufsize < 800  THEN Event_BecomeUnBusy(pCB);

      IF nBCui > 5 THEN Exit; {nBCUI wird alle 8 sekungen auf 0 gesetzt }

      IF zBCState=cWaitIniString THEN
        BEGIN
        REPEAT
          Info := FrameInfo2String_CR (pCB);
        UNTIL (Pos('$]', Info) > 0) OR (Info = '');
        IF Info <> '' THEN
          BEGIN {* Partner ist akzeptiert *}
          zBcState := cWaitHeader;
          TX_InfoOneFrame (pCB,SOFORT, '>'+EOL); {* ok, auf gehts *}
          END;
        END

      ELSE IF zBCState=cWaitHeader THEN
        BEGIN
        REPEAT
          Info := FrameInfo2String_CR (pCB);
          IF Info = 'F>'#13 THEN TX_InfoOneFrame (pCB,SOFORT, 'F>'+EOL) {* Box msste uns nun abschmeissen *}
          ELSE IF (info <> '') AND (upcase(info[1])='S') THEN
             BEGIN
             {* RX: S HARDWA @ DL < DF4QK $208409DB0END
              *     (mglich wre auch noch F>; dann hat box nix mehr, und wenn wir nix haben disconnecten wir)
              *     (mglich wre auch noch SB statt S ...)
              * - Header bauen
              *   - umwandeln BID in fileid   32bit CRC
              * - Extended Header senden (und speichern?)
              * - ok an box schicken}
              bc.sSBLine := info;
              bc.sTitle := '';
              bc.curFileSize := 0;
              bc.crcBody := 0;
              With bc.Header DO
                 BEGIN
                 flags   := 2; { byte offsets....}
                 id      := longint(Calc_CRC16( $7777, @info, length(info)))
                            +6553{6}*longint(Calc_CRC16( $1234, @info, length(info)));
                 typ     := 0;
                 offsetH := 0;
                 offset  := 0;
                 END;
             TX_InfoOneFrame (pCB,SOFORT, 'OK'+EOL); {* Immer akzeptieren *}
             zBCState := cWaitData;
             END;
        UNTIL (INFO = '') OR (zBCState<>cWaitHeader);
        END

      ELSE IF zBCState=cWaitData THEN
       IF pCB^.rxbufsize > 0 THEN
        BEGIN
        {* IF rxbuffsize < 100 THEN
            pCB^.tTimeOut.tickinit := 30 * 100; {* 30Sekunden
            startTimer(pCB^.tTimeOut)
             exit
           else begin
        }
        REPEAT
          IF bc.Header.offset = 0
           THEN BEGIN
                bc.sTitle := FrameInfo2string_CR  ( pCB );
                IF bc.sTitle = '' THEN bc.sTitle := '[No Title]';
                SFHeaderZerlegen(bc.sSBLine);
                MakeBCFileHeader(TRUE{nur Grsse Berechnen});
                bc.Header.offset := bc.LenFHeader;
                END;
          dataSize := GetQueueData (pCB^.RxBuf, pCB^.RxBufSize,
                                    @BcTxbuff[1], sizeof(BctxBuff),
                                    ^Z );
          IF datasize <> 0 THEN
            BEGIN
            Inc(bc.curFileSize,datasize);
            {* Hinweis: Das ^z  kommt meist im einzelnen Paket! *}
            fLastPacket := bctxbuff[ datasize ] = ^z;

            FOR ic := 1 TO datasize DO
              bc.crcBody := (longint(bc.crcBody) + byte(bctxbuff[ ic ])) AND 65535;

            IF fLastPacket
              THEN BEGIN {* letztes Paket *}
                   Dec(dataSize);
                   TX_InfoOneFrame (pCB,SOFORT, '>'+EOL); {* Ok, fertig. Nchstes Mail Anfordern *}
                   zBcState := cWaitHeader;
                   {* Reihenfolge relevant, wg. offset *}
                   DoBCSend(@bcTxBuff,datasize, FALSE{lastpacket});
                   MakeBCFileHeader(FALSE{keine Grsse berechnenen sondern echt auch aussenden!});
                   END
              ELSE DoBCSend(@bcTxBuff,datasize,FALSE{not LastPacket});
            END;
        UNTIL (dataSize=0) OR (zBcState = cWaitHeader); {* $TODO: DCD-abhngige-Steuerung! *}
        END;
      END;

{  msgTimeOut : FnBCHandler ( pCB, msg RX ) selbstAnstoss; }

  msgDiscReq, {* ein DisconectRequest traf ein *}
  msgRetryCountExceeded,
  msgRxDM,
  msgCBDel
        : BEGIN
          zBCState := cNULL;
          END;
  ELSE fnMsgDefault ( pCB, msg );
 END;
{$ENDIF}
END;


{$IFDef not_adlkasljdaklsdaskjdscc}
  const x : ARRAY [1..233] OF Byte = (
                                    $02  ,$18 ,$36 ,$DF ,$1E ,$00 ,$00 ,$00 ,$00  {52:18....6......}
,$AA ,$55 ,$01 ,$00 ,$04 ,$18 ,$36 ,$DF  ,$1E ,$02 ,$00 ,$08 ,$31 ,$45 ,$44 ,$46  {.U....6.....1EDF}
,$33 ,$36 ,$31 ,$38 ,$03 ,$00 ,$03 ,$42  ,$43 ,$54 ,$04 ,$00 ,$04 ,$97 ,$07 ,$00  {3618...BCT......}
,$00 ,$05 ,$00 ,$04 ,$FA ,$94 ,$E0 ,$2E  ,$06 ,$00 ,$04 ,$FA ,$94 ,$E0 ,$2E ,$07  {................}
,$00 ,$01 ,$00 ,$08 ,$00 ,$01 ,$00 ,$09  ,$00 ,$02 ,$8A ,$81 ,$0A ,$00 ,$02 ,0,0{,$C1,$2A}  {................}
     ,$0B ,$00 ,$02 ,$DE ,$00 ,$10 ,$00  ,$05 ,$47 ,$34 ,$41 ,$53 ,$52 ,$11 ,$00  {*........G4ASR..}
,$06 ,$20 ,$20 ,$20 ,$20 ,$20 ,$20 ,$12  ,$00 ,$04 ,$98 ,$3C ,$DF ,$2E ,$13 ,$00  {.      ....<....}
,$01 ,$00 ,$14 ,$00 ,$08 ,$56 ,$48 ,$46  ,$20 ,$40 ,$20 ,$45 ,$55 ,$15 ,$00 ,$06  {.....VHF @ EU...}
,$20 ,$20 ,$20 ,$20 ,$20 ,$20 ,$16 ,$00  ,$04 ,$00 ,$00 ,$00 ,$00 ,$17 ,$00 ,$04  {      ..........}
,$98 ,$56 ,$2E ,$2F ,$18 ,$00 ,$01 ,$00  ,$19 ,$00 ,$01 ,$00 ,$21 ,$00 ,$0C ,$34  {.V./........!..4}
,$36 ,$31 ,$33 ,$30 ,$5F ,$47 ,$42 ,$37  ,$4D ,$41 ,$44 ,$22 ,$00 ,$20 ,$31 ,$34  {6130_GB7MAD". 14}
,$34 ,$4D ,$48 ,$7A ,$20 ,$54 ,$72 ,$6F  ,$70 ,$6F ,$20 ,$72 ,$70 ,$74 ,$3A ,$20  {4MHz Tropo rpt: }
,$4D ,$6F ,$6E ,$20 ,$32 ,$38 ,$20 ,$4E  ,$6F ,$76 ,$20 ,$39 ,$34 ,$2E ,$23 ,$00  {Mon 28 Nov 94.#.}
,$1A ,$44 ,$69 ,$67 ,$69 ,$50 ,$6F ,$69  ,$6E ,$74 ,$20 ,$42 ,$49 ,$44 ,$3A ,$34  {.DigiPoint BID:4}
,$36 ,$31 ,$33 ,$30 ,$5F ,$47 ,$42 ,$37  ,$4D ,$41 ,$44 ,$00 ,$00 ,$00 ,$64 ,$74  {6130_GB7MAD...dt}
);

var p : POINTER;
    crc,ic : WORD;
BEGIN
  p := @x[10];
  crc := 0;
  FOR ic := 10 TO SizeOf(x)-2 DO
    BEGIN
    crc := (longint(crc) + byte(p^)) AND 65535;
    Inc(Word(p));
    END;
{$ENDIF}

END.
