{$I FD_INCL.PAS}
UNIT FD_AXCB;


INTERFACE

USES FD_Def;


  CONST nAXCBAnzahl : INTEGER = 0; {* Anzahl vergebener Blcke *}
        MaxAssignedCBId : WORD = 0; {* oberste Index innerhalb von CB[], *}
                                    {* der Verwendung findet -> Mini Cache *}

  FUNCTION CreateAXCB( ifnr : T_Ifnr) : tp_AXCB;
 PROCEDURE Del_AXCB ( VAR pCB : tp_AXCB);
 PROCEDURE Private_Del_AXCB ( VAR pCB : tp_AXCB );


  CONST    csHeaderStatus2Str=
       {123  112345123451211234567812112311 234567890123456789012345678901234567890}
       ' Id St RxSz TxSz lu01234567 nD FlMP';
  FUNCTION F_AXCBStatus2Str ( i : WORD ) : STRING;

  FUNCTION CheckAXCB( pCB : TP_AXCB; fStore:BOOLEAN ) : BOOLEAN;
 PROCEDURE DamaAus ( axifnr : WORD);
 PROCEDURE ResetDynPara(para:WORD);
 PROCEDURE ClearPaketStatistik;
  FUNCTION Id2CB ( suchId : WORD ) : TP_AXCB; {* Gibt den Zeiger auf den zu ID gehrenden AXCB zurck *}
 PROCEDURE ZaehleConnects (pCB : TP_AXCB; VAR nCon : WORD; VAR nIPakete : longint);
      TYPE T_SUCHCallinDigiMode= (scmFREIER, scmJEDER);
 PROCEDURE SucheCallInDigi ( sArg : STRING; mode : T_SUCHCallinDigiMode; VAR pCB : TP_AXCB);
  FUNCTION Search_AXCB ( pm : tp_mBuf) : tp_AXCB;
  FUNCTION Search_AXCBshPath ( shPath : t_shPath) : tp_AXCB;
  FUNCTION SearchAXCBAscDigi (  f,t,v : String ) : tp_AXCB;

  FUNCTION SizeTxUnAck(pCB : TP_AXCB):LonGint;
  FUNCTION TxWindowUeberschritten(pCB : TP_AXCB):BOOLEAN;

{}

IMPLEMENTATION


USES FD_Mem,   {* wg. MemGet cb[] *}
     FD_timer, {* wg. InitTimer   *}
     FD_state, {* wg. tRemBsyOut  *}
     FD_log,
     FD_Main,
     FD_subr,  {* wg. f_sh2Asc    *}
     FD_mBuf,  {* wg. Del_mBuf    *}
     FD_error, {* wg. StoreStack  *}
     FD_info,  {* wg. Del_Ibcb    *}
     FD_conv,  {* wg. CloseConv   *}
     FD_Sysop, {* wg. DnSet...    *}
     {$IFDEF SCC}  FD_tnc, {* wg. Watchdog *}
       {$ELSE}     FD_crt,
     {$ENDIF}
     FD_div    {* wg. Upper       *}
     ;


{}

PROCEDURE StatistikIntoLog (pCB:TP_AXCB);
{* Von dg6may, unter Protest von mir akzeptiert - ES GEHOERT HIER NICHT HIN!!!*}
  VAR s:STRING;
BEGIN
  WITH pCB^ DO
  if (QSOType=qtINFOBOX) OR
     (QSOType=qtCONVERS) OR
     (QSOType=qtCIRCUITMASTER) THEN
       BEGIN
       s:='';
       IF (wieLog AND (1 shl (iface+3))) <> 0 THEN s:='/ in '+UhrZeit(loginH,LoginM)+' ';
       IF (wieLog AND (1 shl (iface-1))) <> 0 THEN
           s:=s+ 'Ti'+ fStr(wItx)+
                 'r' + fStr(wRRtx)+
                 'n' + fStr(wRNRtx)+
                 'j' + fStr(wREJtx)+
                 'p' + fStr(wRxPolls)+
                ' Ri'+ fStr(wIrx)+
                 'r' + fStr(wRRrx)+
                 'n' + fStr(wRNRrx)+
                 'j' + fStr(wREJrx)+
                 'p' + fStr(wTXPolls);
       IF length(s) > 0 then LogAddEntry (pCB, leLogOut,s);
       END;
END;



FUNCTION F_AXCBStatus2Str ( i : WORD ) : STRING;
  LABEL l_eop;
  VAR s,sQ : STRING;
      j    : BYTE;
BEGIN
 s := '';
 IF i > maxAXCB THEN Goto l_eop;
 IF cb[i] = Nil THEN Goto l_eop;
 WITH cb[i]^ DO
   BEGIN
   sq[0] := #8;
   FOR j := 0 TO 7 DO
     IF      txq[j]                     = Nil THEN sq[j+1] := ''
     ELSE IF txq[j]^.ptTimer            = Nil THEN sq[j+1] := '?'
     ELSE IF txq[j]^.ptTimer^.pbEnabled = Nil THEN sq[j+1] := 'N'
     ELSE CASE txq[j]^.txed OF
     TRANSMITTED : IF txq[j]^.ptTimer^.pbEnabled^ THEN sq[j+1] := ''
                                                  ELSE sq[j+1] := '+';
         WAITING : IF txq[j]^.ptTimer^.pbEnabled^ THEN sq[j+1] := ''
                                                  ELSE sq[j+1] := '*';
{*
 *      SUSPENDED : IF txq[j]^.ptTimer^.pbEnabled^ THEN sq[j+1] := ':'  blag
 *                                                ELSE sq[j+1] := '-';
 *}
       ELSE        IF txq[j]^.ptTimer^.pbEnabled^ THEN sq[j+1] := 'O'
                                                  ELSE sq[j+1] := 'o';
       END; {* CASE *}

    s :=   f_using(i,3)+ '. '
         + FStr( Ord(state) )
         + f_Using(rxBufSize,5)+f_Using(txBufSize,5)
         + f_using(lastAck,2)
         + f_using(nUnbest,1)
         + sq
         + f_using(tries,2)
         + FStr( Ord(fDoTxBuf) )
         + F_Using( Flensburg,3 )
         + FStr(maxframe)
         + 'P'+FStr(iface)
         + ' ' + f_sh2asc (fromCall) +  '' + f_sh2asc (toCall)
         ;
    AppendTimer2Str( t1, s );
    AppendTimer2Str( t2, s );
    AppendTimer2Str( t3, s );

    AddChar(s,' ');
    AddString(s,fStr(t1.TickInit));
    IF pid <> 240 THEN AddString(s,'p'+FStr(pid));
{$IFDEF dama_slave}
    IF fdama THEN AddString(s, ' DAMA');
{$ENDIF}
    IF busy THEN AddString(s,' bsy');
   END;
l_eop:
 f_axcbStatus2Str := s;
END;



FUNCTION SizeTxUnAck(pCB : TP_AXCB):LonGint;
  {- Liefert die Anzahl der auf L3 nicht besttigten Bytes (=gesendete, aber
   - nicht besttigt + noch nicht gesendete Bytes) zurck. Wird z.B. als
   - Vergleich fr TX-Window verwendet
   -}
BEGIN
  SizeTxUnAck := pCB^.TxBufSize+pCB^.nUnbest*pCB^.PACLEN; {- worst Case : -}
END;

FUNCTION TxWindowUeberschritten(pCB : TP_AXCB):BOOLEAN;
BEGIN
  TxWindowUeberschritten :=
    (pCB^.TxBufSize+pCB^.nUnbest*pCB^.PACLEN) > pCB^.txWind;
END;


PROCEDURE ClearPaketStatistik;
  VAR portNr : BYTE;
BEGIN
FOR portNr := 1 TO MAX_IFACE DO  WITH axIFace[portnr] DO
  BEGIN
  brmax         := 0;       brChAvg   := 0;
  nTxInfoNetto  := 0;       nTxBrutto := 0;
  nRxInfoNetto  := 0;       nRxBrutto := 0;
  nITxNetto     := 0;       nITxBrutto    := 0;
  nRRTx     := 0;
  nRNRTx        := 0;       nREJTx    := 0;
  nTxSvPolls      := 0;       nIrx      := 0;
  nRRrx         := 0;       nRNRrx    := 0;
  nREJrx        := 0;       nRxPolls  := 0;
  END;
{$IFDEF DG5MPQ_STA}
  fSta10minMustBeInit:= True;
{$Endif}
END;




FUNCTION CreateAXCB( ifnr : T_Ifnr) : tp_AXCB;
  VAR i   : WORD;
      pCB : tp_AXCB;
BEGIN
  CreateAXCB := Nil;
  pCB := NiL;
  i := 1;
  WHILE ( i<=maxAXCB) AND (cb[i]<>Nil) DO Inc (i); {* suche freien Block *}
  IF i<=maxAXCB THEN {* gefunden *}
    BEGIN
    MemGet ( Pointer(cb[i]), SizeOf (cb[1]^));
    pCB := cb[i];
    pCB^.fMsgHandler := fnMsgDefault;
    IF i>MaxAssignedCBId THEN MaxAssignedCBId := i;
    Inc(nAXCBAnzahl);
    {* Defaultwerte..}
    pCB^.id := i;
    pCB^.setMsg := [];
    pCB^.QSOType := qtNullQSO;
    pCB^.who := USER;
    pCB^.fBEamt := false;
    pCB^.watchmode := 0;
    pCB^.pCv := NiL;    pCB^.pInfoBox := Nil;
    pCB^.divers.pLink := NiL; {* Stellvertretend fuer die Union *}
    pCB^.fMsgHandler := fnMsgDefault;
    pCB^.nMyCall := 0;
    pCB^.virtAdr := 0;
    pCB^.fvirtAdr := false;

    pCB^.iface := ifnr;
    pCB^.aktIfnr := axIFace[ifnr].mapIfnr;
    pCB^.state := DISCONNECTED;    {** pCB^.axVersion := 2; **}
 {  pCB^.l2state := l2disc; }
    pCB^.nr := 0;
    pCB^.nUnbest := 0;    pCB^.lastack := 7; {* Damit das 1.Paket auch ausgesendet wird *}

{$IFDEF DAMA_SLAVE}
    pCB^.fdama := axIFace[ifnr].dama.fSLAVE;
{$ELSE}
    pCB^.fdama := false;
{$ENDIF}

    pCB^.rejsent := FALSE;
    pCB^.pf      := cNULL;
    pCB^.remotebusy := FALSE;   pCB^.busy := False; pCB^.RNRsent := FALSE;
    pCB^.PID      := PID_Text;
    pCB^.nDigi    := 0;
    pCB^.wItx     := 0;  pCB^.wRRtx  := 0; pCB^.wRNRtx := 0; pCB^.wREJtx := 0;
    pCB^.wIrx     := 0;  pCB^.wRRrx  := 0; pCB^.wRNRrx := 0; pCB^.wREJrx := 0;
    pCB^.wTxPolls := 0;  pCB^.wRxPolls := 0;

    pCB^.LoginH := sysTime.Hour; pCB^.LoginM := SysTime.Min;
    pCB^.redirectIfNr := 0;

    FOR i := 0 TO 7 DO pCB^.txq[i] := NiL;
{$IFDEF sammler}
    Fillchar( pCB^.sammler, sizeof(pCB^.sammler), #0);
{$ENDIF}

    pCB^.rxBuf := NiL; pCB^.rxBufSize := 0;
    pCB^.txBuf := NiL; pCB^.txBufTail := NiL; pCB^.txBufSize := 0;
    pCB^.paclen := axIFace[ifnr].paclen_init;
    pCB^.maxFrame := axIFace[ifnr].maxframe_init;
    pCB^.flensburg := 1; {optimal}
    pCB^.TxWind := axIFace[ifnr].TxWindowInit;
    pCB^.RxWind := axIFace[ifnr].RxWindowInit;

    pCB^.tlastPoll := 0;
    pCB^.fIvePolled := false;
    pCB^.messFrack := -1;       pCB^.minfrack := MAXLONGINT;

    pCB^.txdn := 0; pCB^.txdsum:=0;
    pCB^.txdmin :=99999; pCB^.txdmax := 0;

    pCB^.pPartnerCB := NiL;

    InitTimer (pCB^.t1,axIFace[ifnr].t1_init);
    pCB^.t1.timerfunction := t1out;
    pCB^.t1.arg := pCB;

    InitTimer (pCB^.t2, axIFace[ifnr].t2_init);
    pCB^.t2.timerfunction := t2out;
    pCB^.t2.arg := pCB;

    InitTimer (pCB^.t3, axIFace[ifnr].t3_init);
    pCB^.t3.timerfunction := t3out;
    pCB^.t3.arg := pCB;

    {* TTimeOut ist per Definition immer definiert s.FD_DEF *}
    InitTimer (pCB^.tTimeOut, 3600 * 1000);  {* Eine Stunde *}
    pCB^.tTimeOut.timerfunction := tTimeOutout;
    pCB^.tTimeOut.arg := pCB;

    pCB^.retry := axIFace[ifnr].retry_init;
    pCB^.tries := 0;
    END;
  CreateAXCB := pCB;
END;



PROCEDURE DamaAus(axifnr : WORD);
  VAR iCB : WORD;
BEGIN
{$IFDEF DAMA_SLAVE}
  axIFace[axifnr].dama.fSLAVE := FALSE;
  IF DoDnSetPara ( axIFace[axifnr].bindnr, spSETZEDAMAPARA, 0 )=0 THEN ;;
  FOR icb := 1 TO MaxAssignedCBId DO
    IF cb[iCB] <> nil THEN cb[icb]^.fDama := false;
{$ENDIF}
END;


FUNCTION CountPortQSO(portnummer : WORD):WORD;
   VAR i, n : WORD;
BEGIN
  n := 0;
  FOR i := 1 TO MaxAssignedCBId DO
    IF cb[i] <> NiL THEN
      IF cb[i]^.state <> DISCONNECTED THEN
        IF (cb[i]^.iface = portNummer) THEN Inc(n);
  CountPortQSO := n;
END;


PROCEDURE Del_AXCB ( VAR pCB : tp_AXCB );
BEGIN
  IF NOT CheckAXCB (pCB, cSTORE) THEN Exit;
  QueueMsg(pCB,msgCBDel);  {* Letztes Lebenszeichen; siehe auch WorkTx *}
END;


PROCEDURE Private_Del_AXCB ( VAR pCB : tp_AXCB );
  LABEL l_Eop;
  VAR portnummer, iCB, i : WORD;
      j : BYTE;
BEGIN
  IF pCB = NIL THEN Exit;
  iCB := pCB^.Id;
  IF (iCB = 0) OR NOT CheckAXCB (pCB, cSTORE) THEN GOTO l_eop;
  IF (iCB>=1) AND (iCB<=MaxAssignedCBId) THEN
    BEGIN {* gefunden und OK *}
    portnummer := pCB^.iface;

    IF iCB = MaxAssignedCBId THEN
      BEGIN {* Cache nach unten korregieren *}
      REPEAT {* einmal mindestens erniedrigen... *}
        Dec (MaxAssignedCBId);
      UNTIL (MaxAssignedCBId<=1) OR (cb[MaxAssignedCBId]<>NiL);
      END;
    Dec(nAXCBAnzahl);

    DelTimer (pCB^.t1); {* Stoppen UND ungltig machen *}
    DelTimer (pCB^.t2);
    DelTimer (pCB^.t3);
    DelTimer (pCB^.tTimeOut);
    FOR j := 0 TO 7 DO
      BEGIN
{$IFDEF sammler}
      IF pCB^.sammler[j]<>nil THEN Del_mBuf(pCB^.sammler[j]);
{$ENDIF}
      _DI;
      IF pCB^.txq[j] <> NiL THEN
        BEGIN
        IF (pCB^.txq[j]^.txed = TRANSMITTED) AND NOT pCB^.txq[j]^.discard {* sonst hngt der Frame noch in der DEL-Kette *}
	  THEN Del_mBuf(pCB^.txq[j]) {* Mit Sicherheit nich mehr in der TX-QUEUE *}
	  ELSE BEGIN
               {* Wahrscheinlich noch in PmDelRoot drin oder nicht gesendet, also nicht hier lschen *}
	       {*pCB^.txq[j]^.txed := SUSPENDED; Nach mglichkeit nicht mehr senden *}
	       pCB^.txq[j]^.discard := TRUE; {* Lschen besorgt dann der TX-Task *}
	       pCB^.txq[j]^.ptTimer := NiL;  {* Sonst rger, wenn         *}
               {* Hintergrundroutine TROTZDEM nochmals eins dieser Pakete *}
               {* sendet, aber der Speicherplatz von pCB^.t1 schon wieder *}
               {* freigegeben wurde. Dann haut naemlich das Umbiegen des  *}
               {* Freigabeflags Muell in den Speicher, wo er nich hingeht*}
	       END;
        pCB^.txq[j] := NiL; {* sicher ist sicher *}
        END;
      _EI;
      END;
    Del_mBuf_Chain (pCB^.RxBuf);
      pCB^.rxBuf := NiL;
      pCB^.rxBufSize := 0;
    Del_mBuf_Chain (pCB^.TxBuf);
      pCB^.txBuf := NiL;
      pCB^.txBufTail := NiL;
      pCB^.txBufSize := 0;

    {* ggf. Verweis auf sich selber lschen *}
    IF pCB^.pPartnerCB <> Nil THEN
      IF pCB^.pPartnerCB^.pPartnerCB = pCB THEN
        IF CheckAXCB(pCB^.pPartnerCB, cSTORE) THEN
          pCB^.pPartnerCB^.pPartnerCB := NiL;
    pCB^.pPartnerCB := Nil; {* das auf jeden Fall ! *}

    {$IFDEF LogStat} StatistikIntoLog(cb[iCB]);  (* lt.dg6may *) {$ENDIF}

    pCB^.state := INVALID;
    pCB^.id := 0; {- wg. checkAXCB & hartnckigen Pointern -}
    MemFree ( pointer(cb[iCB]), SizeOf(cb[1]^) );
    cb[iCB] := Nil;

    {$IFDEF DAMA_SLAVE}
    IF axIFace[portnummer].dama.fSLAVE THEN
      BEGIN
      WatchDog;
      IF CountPortQSO(portnummer)=0 THEN DamaAus(portnummer);
      END;
    {$ENDIF}

    END;
l_eop:
  pCB := Nil; {* Auf jeden Fall ! *}
END;


PROCEDURE ResetDynPara (para:word);
{* Setzt alle dynamischen L2-Parameter auf die Initialwerte zurck *}
  VAR i,mini,maxi : WORD;
      pIf : ^T_axIFACE;
BEGIN
  IF (para = 0) OR (para > MaxAssignedCBId)
    THEN BEGIN {* Alle *}
         maxi := MaxAssignedCBId;
         mini := 1;
         END
    ELSE BEGIN {* Genau einer }
         maxi := para;
         mini := para;
         END;
  FOR i := mini TO maxi DO IF cb[i] <> NiL THEN
    BEGIN {* $OPT *}
    pif := @axIFace[cb[i]^.iface];
    WITH CB[i]^ DO
      BEGIN
      paclen    := pIf^.paclen_init;
      maxFrame  := pIf^.maxframe_init;
      retry     := pIf^.retry_init;
      messFrack := -1;
      minfrack  := MAXLONGINT;
      t1.tickinit      := pIf^.t1_init;
      t2.tickinit      := pIf^.t2_init;
      t3.tickinit      := pIf^.t3_init;
      END;
    END;
END;


{}

FUNCTION CheckAXCB( pCB : TP_AXCB; fStore:BOOLEAN ) : BOOLEAN;
  {* Testet, ob pCB noch gltig ist. Wenn ja, gebe TRUE zurck *}
BEGIN
  CheckAXCB := FALSE;
  IF NOT CheckMem (pCB, sizeof(pCB^), fStore ) THEN Exit;
  IF pCB = Nil
    THEN BEGIN
         IF fStore THEN StoreStack ( 'C' ,'3');
         END
    ELSE IF (pCB^.id = 0) OR (pCB^.ID>maxAXCB)
           THEN BEGIN
                IF fStore THEN StoreStack ( 'C', '2 '+fStr(pCB^.ID)
                                  +' '+HexAddrString(pCB) );
                END
           ELSE BEGIN
                IF pCB<>cb[pCB^.ID]
                  THEN BEGIN
                       IF fStore THEN StoreStack ( 'C', '1 '+fStr(pCB^.ID)
                                         +' '+HexAddrString(pCB)
                                         +' '+HexAddrString(cb[pCB^.ID]) );
                       END
                  ELSE BEGIN
		       IF (pCB^.iface > 0) AND (pCB^.iface <= MAX_AXIFACE)
                         THEN CheckAXCB := TRUE {* Einziger Punkt, wo alles korrekt ist *}
                         ELSE IF fStore THEN StoreStack ( 'c' ,FStr(pCB^.iface));
                       END;
                END;
END;


FUNCTION ID2CB ( suchId : WORD ) : TP_AXCB;
BEGIN
 IF (suchId > 0) AND (suchId <= maxAXCB)
    THEN id2CB := cb [suchId]
    ELSE id2CB := Nil;
END;


PROCEDURE ZaehleConnects (pCB : TP_AXCB; VAR nCon : WORD; VAR nIPakete : longint);
  VAR i : WORD;
      iAbsAnz     : Longint;
      iDifH,iDifM : INTEGER;
BEGIN
  nCon := 0; nIPakete := 0;
  FOR i := 1 TO MaxAssignedCBId DO
    IF cb[i] <> Nil THEN
      IF MemEQ( @cb[i]^.tocall, @pCB^.tocall, sizeof(cb[1]^.toCall)-1 ) THEN
        BEGIN
        Inc (nCon);
        iAbsAnz := cb[i]^.wItx;
        Inc(iAbsAnz, cb[i]^.wIrx);

        {* Errechne Differenz: SysTime-cb[i]^.logintime *}
        {* $TODO: da gibt es inzwischen eine SUBRoutine fr *}
        iDifh := integer(systime.hour) - cb[i]^.loginH;
        IF iDifh < 0 THEN Inc (iDifh,24);
        iDifm := integer(systime.min) - cb[i]^.loginM;
        IF iDifm < 0 THEN Inc (iDifm,60);
        iDifM := (60*iDifH+iDifM);

        IF iDifM > 5 THEN Inc( nIPakete, 128*iAbsAnz DIV iDifM);  {* 128*I's Pro Minute *}
        END;
END;

{$IFDEF Optiemieren}
FUNCTION CalcHash ( p : tp_Data) : WORD;
  {* Nur 'ne Idee - wird z.Zt. nicht verwendet *}
  VAR i, hash : WORD;
BEGIN
  hash := byArray (p^)[7] and ( $0f SHL 1);
  FOR i := 1 TO  6 DO  hash := hash XOR byArray (p^)[i];
  FOR i := 8 TO 13 DO  hash := hash XOR byArray (p^)[i];
  hash := hash XOR (byArray (p^)[14] and ( $0f SHL 1));
  calcHash := Hash;

  hash := byte(p^) and ( $0f SHL 1);
  FOR i := 2 TO 6 DO BEGIN
                     Inc (word(p));
                     hash := hash XOR byte(p^);
                     END;
  Inc (word(p));
  FOR i := 8 TO 13 DO BEGIN
                      Inc (word(p));
                      hash := hash XOR byte(p^);
                      END;
  calcHash := Hash;

  ASM
    ...
  END;
END;
{$ENDIF}

{}


FUNCTION Search_AXCB ( pm : tp_mBuf) : tp_AXCB;
 {* Suche ein zu dem in PM stehenden Frame ein passendes QSO in der  *}
 {* QSO-Tabelle. Vorl. Version mit linearer Suche - spter Hashkette *}
  VAR i,j   : WORD;
      pCB : tp_AXCB;
      AnzDigi : WORD;
BEGIN
  WatchDog;
  pCB := NiL;
  {* if pm^.virtuellAdress then pCB := cb[f(pm)]; plausen; exit; }
  anzDigi := (pm^.ofsctl-14) DIV 7;
  i := 1;
  WHILE (i<=MaxAssignedCBId) DO
    BEGIN
    IF cb[i]<>Nil THEN WITH cb[i]^ DO
     IF AnzDigi=cb[i]^.nDigi THEN
      IF CmpShCallSSID   ( Addr (fromCall), Addr (by1Array (pm^.pData^) [1]) ) THEN
        IF CmpShCallSSID ( Addr (toCall),   Addr (by1Array (pm^.pData^) [8]) ) THEN
          BEGIN {* jetzt noch den Pfad vergleichen *}
          j := 1;
          WHILE (j <= AnzDigi)
            AND CmpShCallSSID ( Addr( digi[nDigi+1-j]), Addr(by1Array (pm^.pData^) [ 8+7*j ]) )
            DO Inc(j);
          IF (j > AnzDigi) THEN
             BEGIN {* gefunden *}
             Search_AXCB := cb[i];
             Exit;
             END;
          END;
    Inc (i);
    END;
  Search_AXCB := pCB;
END;


FUNCTION Search_AXCBshPath ( shPath : t_shPath) : tp_AXCB;
 {* Suche ein zu dem in shPath stehenden Pfad ein gleichpfadiges QSO in der *}
 {* QSO-Tabelle. Vorl. Version mit linearer Suche - spter Hashkette        *}
  VAR i,j   : WORD;
      pCB : tp_AXCB;
      AnzDigi : WORD;
BEGIN
  Search_AXCBshPath := NiL;
  IF shPath.ilDigi < 1 THEN Exit; {* shPath haben keine To/FromCalls sondern 10 "Digis"... *}
  WatchDog;
  pCB := NiL;
  AnzDigi := shPath.ilDigi-1; {* 0=from,1=to,2=digi1,...,10=Digi8 *}
  i := 1;
  WHILE (i<=MaxAssignedCBId) DO 
    BEGIN
    IF cb[i]<>Nil THEN WITH cb[i]^ DO
     IF AnzDigi=cb[i]^.nDigi THEN
      IF CmpShCallSSID   ( Addr (fromCall), Addr (shPath.digi[0]) ) THEN
        IF CmpShCallSSID ( Addr (toCall),   Addr (shPath.digi[shPath.ilDigi] ) ) THEN
          BEGIN
          j := 1;
          WHILE (j <= AnzDigi) AND
                CmpShCallSSID ( Addr (        digi [nDigi+1-j]),
                                Addr ( shPath.digi [nDigi-j+1+1]) )
            DO Inc(j);

          IF ( j > AnzDigi) THEN
            BEGIN {* gefunden *}
            pCB := cb[i];
            i := maxAXCB+1;
            END;
          END;
    Inc (i);
    END;
  Search_AXCBshPath := pCB;
END;



FUNCTION SearchAXCBAscDigi (  f,t,v : String ) : tp_AXCB;
 {* suche ein zu f,t,v passendes QSO in der QSO Tabelle *}
 {* vorl. Version mit linearer Suche - spter hashwert oder hashkette *}
  VAR i ,j : WORD;
      pCB  : tp_AXCB;
      bool : BOOLEAN;
BEGIN
  SearchAXCBAscDigi := NiL; {* davon gehen wir mal aus *}
  pCB := CreateAXCB (1); {* zunchst einen Hilfsblock fr den Vergleich erzeugen *}
  IF pCB = Nil THEN Exit; {* Fataler Fehler (kein Speicher mehr) ! Sofort abbrechen *}
  Asc2AXCB ( f,t,v, pCB ); {* und mit den Vergleichswerten fllen (gleichzeitig konvertieren) *}
  i := 1;
  WHILE (i<=MaxAssignedCBId) DO
    BEGIN
    IF cb[i]<>Nil THEN
      IF pCB <> cb[i] THEN {* Also nicht den Vergleichsblock mit sich delbst vergleichen...*}
        IF pCB^.nDigi = cb[i]^.nDigi THEN {* Also die Anzahl der Digis muss bei beiden gleich sein *}
          IF cmpShCallSSID   ( Addr (cb[i]^.fromCall), Addr (pCB^.fromCall) ) THEN
            IF cmpShCallSSID ( Addr (cb[i]^.toCall),   Addr (pCB^.toCall) ) THEN
              BEGIN {* TO und FROM sind gleich, nun die Digis prffen *}
              bool := TRUE;
              FOR j := 1 TO pCB^.nDigi DO
                bool := bool AND MemEq ( @cb[i]^.digi[j], @pCB^.digi[j],7);
              IF bool THEN
                BEGIN {* Das isser ! *}
                SearchAXCBAscDigi:= cb[i];
                i := maxAXCB+1; {* Abbruchkriterium setzen *}
                END;
              END;
    Inc (i);
    END;
  Private_Del_AXCB(pCB);
END;



PROCEDURE SucheCallInDigi ( sArg : STRING;
                            mode : T_SUCHCallinDigiMode;
                        VAR pCB  : TP_AXCB);
 {* Suche das Call, das in sARG steht, ob es eine Verbindung *}
 {* mit der Infobox hat. Rckgabe in pCB                     *}
 {*$TODO: Bevorzugungen: erst Kanal x, dann convers, dann anderes u.. *}
 VAR i : WORD;
     shCall : T_ShCall;
     ende : BOOLEAN;
BEGIN
  pCB := NiL;
  AscCall2shift ( f_Upper(sArg), shCall );
  i := 1; ende := FALSE;
  WHILE (i<=MaxAssignedCBId) AND NOT ende DO
    BEGIN
    IF cb[i] <> Nil THEN
      IF MemEq ( @cb[i]^.tocall, @shCall, 6 ) THEN
       IF    ( (mode=scmFREIER) AND (cb[i]^.pPartnerCB = Nil) )
	  OR   (mode=scmJEDER ) {* Gesuchter macht gerade CQ *}
				{* oder LinkSetup oder so... *}
        THEN BEGIN
	     pCB := cb[i];
	     ende := TRUE;
	     END;
    Inc (i);
    END;
END;




BEGIN
  FillChar (cb, SizeOf(cb), #0 {*= NIL*} );
END.
