{$I FD_INCL.PAS}
UNIT FD_AX;

INTERFACE

USES FD_Def;


{}

IMPLEMENTATION

USES FD_Div,
     FD_Subr,
     FD_mBuf,
     FD_Mem,
     FD_Dump,
{$IFDEF ip} x     FD_IP, {$ENDIF}
     FD_Sysop,
     FD_TX, {wg TX_UI}
     FD_Error;

{* Zu FD_AX "gehren" auch direkt Fd_AXCB, FD_State ... *}

CONST csMyName = 'AX';


{}



PROCEDURE AX_RXPacketUp (pm:tp_mBuf);
{* Wird von untenliegenden Schichten aufgerufen
 * pm muss beizeiten durch einen Aufruf von FD_AXCB.ReleaseL1Rxbuf(pm:tp_mbuf)
 * wirder an den Pool zurckgegeben werden.
 * Passiert hier indirekt in FD_Main
 *}
BEGIN
  _DI;
  IF lstRxInUse.Root = NiL
     THEN lstRxInUse.Root := pm
     ELSE lstRxInUse.Tail^.next := pm;
  lstRxInUse.Tail := pm;
  _EI;
END;



{ Treiber fr Loopback }
{$F+}
PROCEDURE Loop_TxPacket( pm : TP_mBuf );
{* kopiert den Tx-Bufer in einen Rx-Buffer um *}
  VAR pNeuBuf : TP_mBuf;
      ifnr    : T_Ifnr;
BEGIN
  _DI;
  IF L1RxBufAvail AND (BUFFSIZE >= pm^.inUse)
    THEN BEGIN {* Buffer noch frei *}
         {* Neuen Buffer holen (mu aus RootRxFree kommen,deswegen geht copymBuf nicht)*}
         pNeuBuf := GetL1Rxbuf;
         _EI;
         {* Kopieren des Pakets *}
         Move( pm^.pData^, pNeuBuf^.pData^, pm^.inUse);
         pNeuBuf^.InUse := pm^.inUse;
         pNeuBuf^.ifnr := ifLoopback;
         pNeuBuf^.ofsCtl := CalcOfsCtl(pNeuBuf);
         pNeuBuf^.next := NiL;
         {* Einhngen in RXQueue *}
         AX_RXPacketUp(pNeuBuf);
         pNeuBuf^.time := fasttick;
         _DI;
         END
    {$IFnDEF scc}
    ELSE BEGIN
         {SwitchStaLed(1,cANSCHALTEN);}
         END;
    {$ENDIF}
    ;
  IF pm^.ptTimer <> Nil THEN pm^.ptTimer^.pbEnabled := pf_FOREVER_TRUE;
  pm^.txed := TRANSMITTED;
  _EI;

  IF pm^.discard THEN Del_mBuf (pm);
END;


{*** s.a. FD_TX ***}

PROCEDURE InitAXIFace;
  {* IFACE mit Default Werten versorgen *}
  VAR j : WORD;
BEGIN
  FillChar( axIFace, sizeof(axIFace), #0 );
  FOR j := 1 TO MAX_axIFace DO WITH axIFace[j] DO
    BEGIN
    valid := FALSE;
    txWindowInit := 512;	{* wird die TX-Queue lnger, so mu die Datenquelle pausieren *}
    rxWindowInit := 512;	{* wird die RX-Queue lnger, so geht der DIGI lokal in RNR *}
    iPollSchwelle := 40;
    asMyCall  := 'TE1ST'; AscCall2shift ( asMyCall,  Call);
    asMyIdent := 'IDENT'; AscCall2shift ( asMyIdent, Ident);
    minSSID := 0;    maxSSID := 7;
    l2DigiOn := TRUE;      ptT_Mode := pttNORMAL;
    mapIfnr := j;
    art     :=aUSER;
    l2DigiOn  := TRUE;	    UIMode    := uiAlle;
    t1_init   := 150;	    t2_init   := 50;
    t3_init   := 54000;
    retry_init	 := 20;     paclen_init  := 256;
    maxFrame_init:= 4;
{$IFDEF DAMA_SLAVE}
    dama.ftLastRxDAMABit := 0;
    dama.fSLAVEALLOWED := TRUE; {* Erstmal immer erlaubt *}
    dama.fSLAVE := FALSE;
{$ENDIF}
    END;
END;



{---------------------------------------------------------------------}

PROCEDURE Kommandozeile(VAR sArg : STRING; devNr : BYTE);
  CONST COMANDS1 =
{ 1}  'FRACK T1 RESPTIME T2 CHECK T3 RETRY MAXFRAME PACLEN TXWINDOW '+
      'RXWINDOW IPOLL L2DIGI MINSSID MAXSSID UINO UIALL UINOAX25 UITXD '+
      'PTTOFF PTTNORMAL MYCALL MAP INIT LOOP BIND MYIDENT IDENT USER '+
      'INTERLINK TERMINAL ';

       cmFRACK=1;     cmT1=2;      cmRESPTIME=3;    cmT2=4;
       cmCHECK=5;     cmT3=6;      cmRETRY=7;       cmMAXFRAME=8;
       cmPACLEN=9;    cmTXWINDOW=10;

       cmRXWINDOW=11; cmIPOLL=12;  cmL2DIGI=13;     cmMINSSID=14;
       cmMAXSSID=15;  cmUINO=16;   cmUIALL=17;      cmUINOAX25=18;
       cmUITXD=19;

       cmPTTOFF=20;   cmPTTNORMAL=21; cmMYCALL=22; cmMAP=23;
       cmINIT=24;     cmLoop=25;      cmBIND=26;   cmMYIDENT=27;
       cmIDENT=28;    cmUSER=29;      cmINTERLINK=30; cmTERMINAL=31;

  CONST cmdTab1: ARRAY [1..length(COMANDS1)] OF CHAR = COMANDS1;
  VAR   lDevNrDn,para : Longint;
        sZwisp : STRING;
        sDn : STRING;
        p : POINTER;
        x : BYTE;
BEGIN
WITH axIFace[devNr] DO
  REPEAT
    x := ScanStr (sArg, @cmdTab1, sizeOf (cmdTab1));
    para := ScanforNum(sArg); {* Wenn keine Zahl, wird ein sehr hoher Wert verwendet *}
    CASE x OF
      cmINIT : ;{axIFace[devnr].valid :=  true;}
      cmLOOP : BEGIN
               bindnr := 0;
               ifLoopback := devNr;
               fLoopBack:=true;
               procTxPacket := Loop_TxPacket;
               sNameDn := csMyName;
               devNrDn := devNr;
               valid := true;
               END;
      cmBIND : BEGIN  { BIND kiss 3 }
               ScanForText (sArg, sDn );
               ldevNrDn := ScanforNum(sArg);
               bindnr := DoBind( csMyName,devnr, sDn, ldevNrDn );
               IF bindnr > 0 THEN
                 BEGIN
                 {* Hole die SendeRoutine *}
                 p := Pointer( Register[bind[bindnr].regNrDn].procSetPara (
                      bind[bindnr].devNrdn, spHOLEPROC, ord(hpTxPacket) )
                 );
                 axIFace[devnr].procTxPacket := TFN_TxPacket(p);
                 {* Der Hardware noch meine Nummer mitteilen *}
                 IF DoDnSetPara(bindnr, spSETZEWertIFACENr, devNr) = 0 THEN;;;
                 {* und noch eben speichern des Protokollnamens (nur so) *}
                 sNameDn := sDn;
                 devNrDn := devNr;

                 valid := true;
                 END;
               END;
      cmFrack,
      cmT1    : IF para <= 3000 THEN t1_init := para * (10 DIV _clkTick);  {* Eingabe in 10ms, FRACK*}
      cmRESPTIME,
      cmT2    : IF para <= 3000 THEN t2_init := para * (10 DIV _clkTick);  {* Eingabe in 10ms, RESPTIME, t2 *}
      cmCHECK,
      cmT3    : IF para <= 600  THEN t3_init := para * longint (1000 DIV _clkTick); {* in Sek. CHECK, T3 *}
      cmRETRY : IF para < 256 THEN retry_init := para; {* RETRY *}
      cmMAXFRAME
              : IF para <   8 THEN maxFrame_init := para; {* MAXFRAME *}
      cmPACLEN
              : IF para < 500 THEN paclen_init := para; {* PACLEN *}
      cmTXWINDOW
              : IF para < 32767 THEN TXWindowInit := para;   {* TXWINDOW *}
      cmRXWINDOW
              : IF para < 32767 THEN RXWINDOWInit := para;   {* RXWINDOW *}
      cmIPOLL : IF para < 256 THEN iPollSchwelle := para;
      cmL2DIGI: Toggle (nil, l2DigiOn,'L2-Digip.Port '+FStr(devNr),sArg,para );
      cmMINSSID
              : IF para <= 15 THEN minSSID := para; { $TODO: only bei DigiSetup? *}
      cmMAXSSID
              : IF para <= 15 THEN MaxSSID := Para;
      cmUINO  : uiMode := uiKeine;
      cmUIALL : uiMode := uiAlle;
      cmUINOAX25
              : uiMode := uiNoAx25;
      cmUITXD : uiMode := uiTXD;
      cmPTTOFF: ptt_mode := pttOFF;
      cmPTTNORMAL
              : ptt_mode := pttNORMAL;
      cmMYCALL: BEGIN
                ScanForText(sArg,sZwisp);
                asMyCall := f_Upper(sZwisp);
                AscCall2shift ( asMyCall, call);
                END;
     cmIDENT,
     cmMYIDENT: BEGIN
                ScanForText(sArg,sZwisp);
                asMyIdent := f_Upper(sZwisp);
                AscCall2shift ( asMyIdent, ident);
                END;

      cmMAP   : IF para <= MAX_IFACE THEN mapIfnr := para  ;
      cmUSER  : art := aUSER;
      cmINTERLINK
              : art := aINTERLINK;
      cmTERMINAL
              : art := aTERMINAL;


          ELSE BEGIN
               END
      END;
  UNTIL x = 0;
END;


{$F+}
FUNCTION AX_SetPara ( devnr : BYTE; what:T_setPara; wert:longint):LONGINT;
  TYPE T_PSTRING = ^STRING;
  VAR pm : TP_MBUF;
      s : STRING;
BEGIN
WITH axIFace[devnr] DO
  BEGIN
  AX_SetPara := speOK;
  CASE what OF
    spKOMMANDOZEILE
      : BEGIN
        Kommandozeile( T_PSTRING(wert)^, devnr );
        Exit;
        END;
    spHOLEPARAMSTRING
      : BEGIN
        sGlobReturn := F_Sh2Asc(IDent) +  ':' + f_sh2Asc(Call)
                       + ' ' + fStr(MinSSID)+'-'+fStr(MaxSSID)
                       + ' ';
        AddString(sGlobReturn,asAXIFART[art]);
        IF fLoopBack THEN AddString(sGlobReturn,' loop');
        CASE uiMode OF
           uiKeine  : s := 'no';
           uiAlle   : s := 'all';
           uiNoAx25 : s := 'pid';
           uiTxd    : s := 'txd';
           END;
        AddString(sGlobReturn, ' L2rep:' + F_Bool2OnOff(l2DigiOn)
                             + ' UIrep:' + s
                             + ' pttAllow:'+F_Bool2OnOff(ptt_Mode = pttNormal));

{$IFDEF dama_slave}
        IF dama.fSlave THEN AddString(sGlobReturn, ' lastDAMAPoll:'+fStr(fasttick-dama.ftLastRxDAMABit));
{$ENDIF}
        AddString(sGlobReturn,
                   ' map:'    + fStr(mapIFNr)
                   + EOL_HOLEPARAMSTRING +
                    't1:'+f_usingReal(t1_init * _ClkTick / 1000,1,1) + {* in s *}
                   ' t2:'+f_usingReal(t2_init * _ClkTick / 1000,0,1) + {* in s *}
                   ' t3:'   + fStr(t3_init  DIV (1000 DIV _ClkTick)) + {* in s *}
                   ' n:'    + fStr(retry_init)    +
                   ' o:'    + fStr(maxFrame_init) +
                   ' pl:'   + fStr(paclen_init )  +
                   ' iT:'   + fStr(iPollSchwelle) +
                   ' tw:'   + fStr(txWindowInit)  +
                   ' rw:'   + fStr(rxWindowInit)
                   );
        AX_SetPara := Longint(@sGlobReturn);
        END;
    spHoleVAL
      : IF wert = ord(hvBINDNR) THEN AX_SetPara := bindNr;

    spHoleProc
      : BEGIN
        IF wert= Ord(hpRXPacketUp) THEN AX_SetPara := LongInt(@AX_RXPacketUp);
        END;
{$IFDEF SLIP}
    spTXPacket
      : BEGIN
{Writeln('--AX: txPacket:',devnr,'--',HexLiString(longint(pCBGlob)),'--');}
        pm := tp_mbuf(wert);
        pm^.ifnr := devNR;
        IF pCBGlob = nil
          THEN TxUi ( pm^.pData, pm^.inUse, devnr, 'DG9EP','DG1KJD','DB0ME',cMELD,PID_IP)
          ELSE Tx_MemBlock ( pCBGlob, SOFORT, pm^.pData, pm^.inuse);
        END;
{$ENDIF}
    ELSE {* case *} AX_SetPara := speNNCMD;
  END;
 END;
END;


BEGIN
  InitAXIFace;
  DoRegister(csMyName, 1,MAX_AXIFACE, AX_SetPara);
END.
