{$I FD_INCL.PAS}
UNIT FD_AT;

INTERFACE

USES FD_Def,
     FD_Host;

PROCEDURE InitAT(VAR host:t_host; sCmd : String);
PROCEDURE ATRxChar;


{}

IMPLEMENTATION

USES FD_Div,
     FD_Subr,
     FD_mBuf,
     FD_AXCB,
     FD_Circ,   {* wg. Reconnected *}
     FD_Main,   {* fnMsgDefault *}
     FD_State,  {* wg. Try2Connect *}
     FD_Info,   {* wg. OpenInfoBox (ESC &p scc 1....) *}
     {$IFDEF scc}   FD_TNC,
     {$ELSE}        FD_CRT,DOS,
     {$ENDIF}
     FD_Moni,
     FD_Task,
     FD_AR,
     FD_Mem,
     FD_TX,
     FD_Sysop,
     FD_Error;


TYPE T_ATBlock = RECORD
        host     : T_HOST;
        sKommand : String;
        mode     : (eNULL,eTRANSP,eSLIP);
        pCBHayes : TP_AXCB;
        bindnr  : WORD; {* Index von self in bind[] *}
        sSLIPCFG1,sSLIPCFG2 : STRING;
        ProcRx1Char : TFN_RX1CHAR;
        ProcTx1Char : TFN_TX1CHAR;
        ProcNRxCHAR : TFN_NRXCHAR;
        ProcNTXChar : TFN_NTXChar;
       END;
VAR at : T_ATBlock;





PROCEDURE SendChar(ch:Char);
BEGIN
 WHILE at.Host.ProcNTXCHAR = 0 DO
   BEGIN {* Kein Platz zum Senden! *}
   Inc(Count[cntV24OR]);
   TaskSwitch;
   END;
 at.Host.ProcTx1Char(ch);
END;


PROCEDURE SendStr ( {$IFDEF VER70} CONST {$ENDIF} s : STRING );
  VAR i : BYTE;
BEGIN
  FOR i := 1 TO length(s) DO SendChar(s[i]);
END;

PROCEDURE AXIP2ip(pCB:tp_axcb);
{* Auspacken eines IP-Frames aus ax25 *}
  VAR pmIP : TP_mBuf;
BEGIN
  REPEAT
    pmIP := GetMBufFromQueue (pCB^.RxBuf);
    IF pmIP <> nil THEN
      BEGIN
      Dec (pCB^.RxBufSize, pmIP^.inUse);
      {Umwandeln in slip, und ergebniss ber die V24 senden}

      Del_mBuf (pmIP);  {* GetMBufQueue schreibt vor, dass *wir* den Buffer freigeben muessen *}
      END;
  UNTIL pmIP = nil;
END;



{$F+}
PROCEDURE MsgHayes ( pCB : tp_axcb;  msg : T_Msg ); {$IFNDEF AllFar} {$F-} {$ENDIF}
  VAR info, s : STRING;
BEGIN
CASE msg OF
  msgReconnect,
  msgConnectSuccess
    : BEGIN
      SendStr(CR+'Connected'+CR);
      at.Host.fHayesAktiv := true;
      END;

  msgRX
    : BEGIN
      IF Not TxWindowUeberschritten(pCB) THEN
        BEGIN
        IF      at.mode = eSLIP   THEN AXIP2ip (pCB)
        ELSE IF at.mode = eTRANSP THEN SendStr( FrameInfo2str( pCB ) )
        ;
        END;
      END;

  msgDiscReq, {* ein DisconectRequest traf ein *}
  msgRetryCountExceeded,
  msgRxDM,
  msgCBDel
        : BEGIN
          SendStr(CR+'NO CARRIER'+CR);
          at.Host.fHayesAktiv := false;
          END;
  ELSE fnMsgDefault ( pCB, msg );
 END;
END;



PROCEDURE ATRxChar;
{* Wird regelmssig aufgerufen, wenn mind. ein Zeichen da ist *}
  VAR ch:Char;
BEGIN
  ch := host[1].ProcRx1Char;
  at.sKommand := ch;
  WHILE (at.host.ProcNRXCHAR>0) AND (Length(at.sKommand) <250) DO
    BEGIN
    ch := at.host.ProcRx1Char;
    AddChar(at.sKommand,ch)
    END;
  Tx_Info(at.pCBHayes, SOFORT, at.sKommand);
END;



PROCEDURE DoATCmd(sCmd : String);
  VAR pNewCB : TP_AXCB;
      ifnr : BYTE;
      sWhat, sto,svia,sIf : STRING;
BEGIN
  {* ATDP   1 DG1KJD DB0ME     =   Whle fr normalen Modus (Transparent, pid=f0)  *}
  {* ATDT   1 DG1KJD DB0ME     =   Whle fr SLIP Modus (pid=cc)  *}
  ScanForText ( sCmd, sWhat);
  IF      sWhat = 'ATDP' THEN at.mode := eTRANSP
  ELSE IF sWhat = 'ATDT' THEN BEGIN {Initv24/kiss}
                              at.mode := eSLIP;
                              {v24 ber Kiss umleiten}
                              END
  ELSE BEGIN SendStr(CR+'OK'+CR); Exit; END;
  ScanForText ( sCmd, sIf);
  ScanForText ( sCmd, sTo);
  ScanForText ( sCmd, sVia);
  ifnr := f_Val(sIf);
  pNewCB := Try2Connect ( Ifnr,
                           axIFace[Ifnr].asMyCall ,
                           sTo,
                           sVia, cNOINCSSID );
  IF pNewCB <> Nil THEN
    BEGIN
    pNewCB^.who := auto;
    pNewCB^.fMsgHandler := msgHayes;
    at.pCBHayes := pNewCB;
    END;
END;



PROCEDURE InitAT(VAR host:t_host; sCmd : String);
BEGIN
  at.Host := host;
  at.sKommand := '';
  DoATCmd(sCmd);
END;




END.

