UNIT FD_AR;
{- Autorouter: gehrt zu FD_AX (AX.25 Treiber) -}

INTERFACE
{$I FD_INCL.PAS}

USES fd_def;

FUNCTION TryToConnectShPath ( shPath : T_ShPath ) : TP_AXCB;
FUNCTION GetLocalSubStationLinkNr( pCB  : TP_axCB; pM   : TP_mBuf) : BYTE;
    TYPE T_DoConnect = (cCONNECT,cNOCONNECT);
FUNCTION UIRoute  ( VAR pCB:TP_AXCB ) : BOOLEAN;
FUNCTION TryToConnectRoute  (pm:tp_mBuf; pCB:tp_axcb; VAR pNewCB:TP_AXCB ) : BOOLEAN;
FUNCTION SearchForPath  (shpArg    : T_ShPath;
                         pCB       : tp_axcb;
                         DoConnect : T_DoConnect;
                     VAR sRet      : STRING;
                     VAR pCBRet    : tp_axcb) : BOOLEAN;

 FUNCTION AR_SearchRoute ( ziel : T_shCall;
                           ZielEqTo : BOOLEAN;
                       VAR ifnr : T_Ifnr;
                       VAR via : STRING ) : T_LZ;
VAR AR_GlobReturn : BYTE; {* 0 = Nicht via FlexNet gefunden oder
			   * direkter LinkPartner (auch via DummDigis),
			   * sonst Linknr);

{}

IMPLEMENTATION

USES {$IFDEF SCC} fd_tnc,
     {$ELSE}	  fd_crt,
     {$ENDIF}
     fd_mh,
     fd_flex,
     fd_Div,
     fd_state,  {* wg. Event_LocalStart *}
     fd_subr,
     FD_AX,     {* wg. AX-Variable *}
     fd_netrom,
     fd_axcb,
     fd_link
     ;


FUNCTION GetLocalSubStationLinkNr( pCB  : TP_axCB; pM : TP_mBuf) : BYTE;
  {* Schaue nach, ob das "Dest"Call mit genau dieser SSID in der Linkliste
   * steht. Wenn ja, dann Index des Links zurckgeben, sonst 0 *}
  VAR n : WORD;
BEGIN
  GetLocalSubStationLinkNr := 0;
  n := 1 ;
  WHILE ( n<=nLinks )
    AND	NOT ( Link[n].Valid  AND
               ( (CmpShCall (pCB^.fromCall, Link[n].Call))  {* stimmt Call ... *}
                 AND ( Link[n].ssid_von <= ( (byte(pCB^.fromCall[7]) DIV 2) AND 15 ) ) {* und SSID ? *}
                 AND ( Link[n].ssid_bis >= ( (byte(pCB^.fromCall[7]) DIV 2) AND 15 ) )
               )
	    ) DO Inc (n);
  IF n <= nLinks THEN
    BEGIN  {* gefunden *}
    GetLocalSubStationLinkNr := n;
    END;
END;



VAR AR_ZielEqTO : BOOLEAN;
{}
{$IFDEF sdfsdfsdf}    DOKU BERARBEITEN  !
Eingabe: pCB  Zeiger auf einen Pfad, der geroutet werden will
              Dieser ist schon UMGEDREHT, d.h. fromCall ist das Ziel ZU dem
              das Frame soll, digi[1] ist der letzte Digi, digi[nDigi] der
              erste.
Ausgabe: pCB  Zeigt azf den CB wo alles komplett richtig drin ist (pfad
              und Iface). Kann sofort verwendet werden, z.B. fr TryToConnect

Arbeitsweise: 1. Zu suchende Call wird isoliert
                 nDigi = 0 dann FromCall
                 nDigi > 0 dann
                             nMyCall = 0 dann FromCall
                             nMyCall > 1 dann Digi[nMyCall-1]
              2. Suche einen Pfad zum Ziel
                 wenn ziel = myLinkCall dann bilde Pfad;gehe zu 3.
                 wenn ziel = myifaceCall dann setze currIFace neu;
                                              erhoehe nMyCall;
                                              gehe zu 1;
                 andere Pfadsuch methoden.
              3. wenn gefunden
                    krze Orignalpfad
                    Mische Original und neuen Pfad (hBit setzen)
{$ENDIF}



PROCEDURE ShPath2pCB ( shPath : T_ShPath; VAR pCB : TP_AXCB);
  {* Schiebe Daten aus shPath nach pCB^ *}
  VAR i : Word;
BEGIN
  IF (shPath.ilDigi <> shpINVALID) AND (shPath.ilDigi>=1 ) THEN
    BEGIN {* Wenn gltig, AXCB ndern *}
    pCB^.iface    := shPath.Ifnr;
    pCB^.ToCall   := shPath.digi[shPath.ilDigi];
    pCB^.FromCall := shPath.digi[0];
    pCB^.nMyCall  := shPath.nMyCall;
    IF shPath.ilDigi >=10 THEN pCB^.nDigi := 8
                          ELSE pCB^.nDigi := shPath.ilDigi-1;
    FOR i := 1 TO pCB^.nDigi DO
      BEGIN
      IF i <= shPath.nMyCall  {* H-Bit setzen *}
        THEN Byte(shPath.Digi[i][7]) := Byte(shPath.Digi[i][7])  OR      $80
        ELSE Byte(shPath.Digi[i][7]) := Byte(shPath.Digi[i][7]) AND (NOT $80) ;
      Byte(shPath.Digi[i][7]) := Byte(shPath.Digi[i][7]) AND $FE; {* EOA lschen *}
      pCB^.Digi[i] := shPath.Digi[i];
      END;
    {* EoA setzen *}
    byte(pCB^.toCall [7]) := byte(pCB^.toCall [7]) AND $FE; {* EoA auf 0 *}
    IF pCB^.nDigi = 0
      THEN BEGIN
           byte(pCB^.fromCall [7])         := byte(pCB^.fromCall [7]) OR $01
           END
      ELSE BEGIN
           byte(pCB^.fromCall [7])         := byte(pCB^.fromCall [7]) AND $FE; {* EoA auf 0 *}
           byte(pCB^.digi [pCB^.nDigi][7]) := byte(pCB^.digi[pCB^.nDigi][7]) OR $01;
           END;
    END;
END;

FUNCTION TryToConnectShPath ( shPath : T_ShPath ) : TP_AXCB;
  {* Baue einen Connect mit den in shPath stehenden Daten auf. Kein AR *}
  VAR pCB : TP_AXCB;
      i   : Word;
BEGIN
  TryToConnectShPath := NiL;
  IF (shPath.ilDigi <> shpINVALID) AND (shPath.ilDigi>=1) THEN
    {* Suche, ob es bereits ein gleichnamiges QSO gibt... *}
    BEGIN
    pCB := Search_AXCBshPath ( shPath );
    IF (pCB = NiL) OR (pCB^.iface<>shPath.Ifnr) THEN
      BEGIN
      {* ... wenn nein, AXCB bauen *}
      pCB := CreateAXCB(shPath.Ifnr);
      ShPath2PCB ( shPath, pCB); {* ... und belegen *}

      {* Bei SABM bercksichtigen wir die Anzahl der Digis (besser die LZ !) in FrAck. Nachdem der  *}
      {* Connect zustande gekommen ist, setzen wir Ihn wieder zurck (in FD_STATE) *}
      pCB^.t1.tickinit := Longint (axIFace[pCB^.iFace].t1_init) + Longint(300*pCB^.nDigi);
      Event_LocalStart (pCB);        {* ...und SABM starten *}
      TryToConnectShPath := pCB;
      END;
    END;
END;

{}

FUNCTION AR_MatchIfaceShCall (pShCall:TP_ShCall; VAR intifnr: BYTE) : BOOLEAN;
{* Schaut nach ob shT ein IFACENAME ist. Wenn ja wird die zugehrige *}
{* Ifacenr nach INTIFNR geschrieben und TRUE zurckgegeben. Zum erkennen *}
{* von Selbstconnecten *}
  VAR n : WORD;
      found : BOOLEAN;
BEGIN
  n := 1; found := FALSE;
  WHILE ( n<=MAX_iface ) AND (NOT found) DO
    BEGIN
      IF  ( NOT axIFace[n].valid )
       OR ( NOT MemEq (pShCall, @axIFace[n].Call, Sizeof(axIFace[1].Call)-1))
       OR ( axIFace[n].MinSSID > ( (byte(pShCall^[7]) DIV 2) AND 15 ) )
       OR ( axIFace[n].MaxSSID < ( (byte(pShCall^[7]) DIV 2) AND 15 ) )
       	  THEN Inc (n)
          ELSE found := TRUE;
    END;
  IF found THEN intifnr := n;
  AR_MatchIfaceShCall := found;
END;


FUNCTION AR_MH (pShCall:TP_ShCall; VAR shPath:T_ShPath) : BOOLEAN;
{* gibt den Pfad zurck, ber das pShCall^ zuletzt gehrt wurde. *}
{* Wenn nicht, wird FALSE zurckgegeben                          *}
  VAR n : WORD;
      i : WORD;
      s : STRING;
BEGIN
  n := 1;
  WHILE ( n<=nmHeard ) AND
	(NOT MemEq (pShCall, @pmHeard^[n].Call, Sizeof (t_shCall)-1)) DO
	Inc (n);

  {* MHeard ist nicht sinnvoll, wenn er ueber einen NET/ROM Interlink kam, *}
  {* denn NET/ROM ist nicht Adresstransparent *}
  IF n <= nmHeard THEN {* ein Kanidat ist gefunden... *}
    IF pmHeard^[n].nDigi = 0 THEN {* ..der direkt gehrt wurde... *}
      IF axIFace[pmHeard^[n].ifnr].art = aINTERLINK THEN {* auf einem Interlink ! *}
	n := nmHeard+1; {* nee, den wollen wir nicht *}

  IF n <= nmHeard
    THEN BEGIN
         shPath.ilDigi := 0;
	 FOR i := pmHeard^[n].nDigi DOWNTO 1 DO
           BEGIN
	   shPath.Digi[shPath.ilDigi] := pmHeard^[n].Digi[i];
           Inc (shPath.ilDigi);
           END;
         shPath.Digi[shPath.ilDigi] := pShCall^ ; {* Damit auch das gesuchte eingetragen wird *}
         shPath.ifNr := pmHeard^[n].ifnr;
         END;
  AR_mh := (n<=nmHeard);
END;


FUNCTION AR_LinkListe (pShCall:TP_ShCall; VAR shPath:T_ShPath) : BOOLEAN;
  {* gibt den Pfad zurck, ber den das Ziel laut Linkliste     *}
  {* erreicht werden kann. Wenn nicht, wird FALSE zurckgegeben *}
  VAR n : WORD;
      lz : T_lz;
BEGIN
  AR_LinkListe := FALSE;
  lz := 0;  n := 1 ;
  WHILE ( n<=nLinks )
    AND	(    (NOT Link[n].Valid)
          OR (NOT CmpShCall (pShCall^, Link[n].Call))  {* stimmt Call ... *}
          OR ( Link[n].ssid_von > ( (byte(pShCall^[7]) DIV 2) AND 15 ) ) {* und SSID ? *}
          OR ( Link[n].ssid_bis < ( (byte(pShCall^[7]) DIV 2) AND 15 ) )
	) DO Inc (n);
  IF n <= nLinks THEN
    BEGIN  {* gefunden *}
    lz := link[n].tSchnitt;
    LinkPort2ViaShPath ( n, shPath );
    shPath.Digi [shPath.ilDigi] := pShCall^; {* Zielcall auf jeden Fall kopieren, damit SSID stimmt *}
    AR_LinkListe := TRUE;
    END;
END;

FUNCTION AR_Flex (pShCall:TP_ShCall; VAR shPath:T_ShPath) : BOOLEAN;
{* gibt den Pfad zurck, ber die das Ziel laut FlexRouter erreicht werden *}
{* kann, Inkl. spPath ? Wenn nicht, wird FALSE zurckgegeben *}
  VAR zi,LinkNr : INTEGER;
BEGIN
  AR_Flex := FALSE;
  IF NOT useFlexNet THEN Exit;
  {* Sucht in der ZielTabelle, kehrt mit positivem Index zurck, wenn ok. *}
  {* FALSE= SSID muss nicht GENAU uebereinstimmen, sondern nur in den Bereich passen *}
  zi := FlexSucheZiel ( pShCall^, ( byte(pShCall^[7])  AND 30 ) SHR 1, FALSE);
  IF zi <= 0 THEN Exit; {* Ziel nicht bekannt *}

  {* Stelle nun den Weg zusammen *}
  linkNr := paZiel^[zi].lkUsed;  {* NachbarIndex (Link) *}
  IF LinkNr= 0 THEN Exit; {* es gibt kein Route mehr *}
  {** lz := ziel[zi].lz[bi]; *}
  LinkPort2ViaShPath ( linkNr, shPath );
  {* Wenn Ziel nicht gleichzeitig der LinkPartner, dann ZielCall dranhngen ansonsten wird berschrieben *}
  IF NOT CmpShCall(pshCall^,link[linknr].call) THEN Inc(shPath.ilDigi);
  shPath.Digi [shPath.ilDigi] := pShCall^; {* Zielcall auf jeden Fall kopieren, damit SSID stimmt *}
  AR_Flex := TRUE;
END;


{FUNCTION AR_MatchPortCall( pShCall:TP_ShCall; VAR shPath:T_ShPath) : BOOLEAN; }
{* Schaut nach ob pSHCall die Form PORT<n>[<m>] hat. {FALC ohne <m>) werden in *}
{* nicht in der LinkListe behandelt! Wenn ja, so alles notwendige in shPath rein *}
 { VAR rPortNr : Byte;
BEGIN
  AR_MatchPORTCALL := FALSE;
  IF MemEq (pShCall, @cshPORT, 4 ) THEN
   IF InRange( Byte(pShCall^[5]), 2*ord('0'), 2*ord('9')) THEN
     BEGIN
     shPath.ifNr  := Byte(pShCall^[5]) div 2 - 48;
     AR_MatchPORTCALL := TRUE;
     END;
END;  }


{}

PROCEDURE CutPath ( VAR shPath : T_ShPath );
  {* Krze den Pfad shPath, indem Digi[2]-Digi[nMyCall-1] entfernt *}
  {* wird, falls vorhanden *}
  VAR n : SHORTint;
BEGIN
WITH shPath DO
  IF (ilDigi >= 2) AND (shPath.nMyCall>=3) THEN
    BEGIN
    n := shPath.nMyCall - 2 ;
    IF n>0 THEN BEGIN
                WatchDog;
                Move (shPath.Digi[nMyCall], shPath.Digi[2], (ilDigi-nMyCall+1)*Sizeof(shPath.Digi[2]));
                Dec( ilDigi,n );
                Dec( nMyCall,n );
                END;
    END;
END;


  TYPE T_Routing = (cNIL,cIFACE,cMYLINK,cFLEX,cLINK,cMH);

FUNCTION RouteIt (defaultifnr : BYTE;
                  pShZiel     : TP_ShCall;
              VAR shpRet      : T_ShPath) : t_routing;
{* Wir suchen pShZiel^. Ergebnispfad wird in shpRet zurckgegeben *}
{* die Aufforderung kam ber Interface defaultifnr                *}
  LABEL l_eop;
  VAR linkNr      : T_LinkId;
      bZwiSp : BYTE;
BEGIN
  RouteIt := cNIL;
  shpRet.ilDigi := shpINVALID; {* Rckgabewert zunchst mal ungltig machen *}


{  IF AR_MatchPortCALL(pshZiel, shpRet) THEN
    BEGIN {* suche nach "PORT.." *
    RouteIt := cOther;
    Goto l_eop;
    END;
}
  {* Schaut nach ob shT ein IFACENAME ist. Wenn ja wird die zugehrige *}
  {* Ifacenr nach INTIFNR geschrieben und TRUE zurckgegeben.          *}
  IF AR_MatchIfaceShCall (pShZiel, bZwiSp) THEN
    BEGIN
    RouteIt := cIFACE;
    shpRet.ifnr := bZwiSp;
    shpRet.nMyCall := 0;
    Goto l_EoP;
    END;

  {* Testen Flexnet-Liste *}
  IF AR_Flex (pShZiel, shpRet) THEN
      BEGIN {* ok, gefunden, sofort zurck *}
      RouteIt := cFLEX;
      Goto l_eop;
      END;

  {* Testen Interlinks *}
  IF AR_LinkListe (pShZiel, shpRet) THEN
      BEGIN {* ok, gefunden, sofort zurck *}
      RouteIt := cLINK;
      Goto l_eop;
      END;

  {* Testen MH-Liste *}
  IF AR_MH (pShZiel, shpRet) THEN
      BEGIN {* ok, gefunden, sofort zurck *}
      RouteIt := cMH;
      Goto l_eop;
      END;

  {* Testen NetRom *}

  {* Hier angekommen, haben wir KEINEN weg gefunden. Also setzen wir als *}
  {* Ergebnis das gesuchte Call OHNE jeden Pfad, sowie das bergebene IFace *}
  shpRet.Digi[0] := pShZiel^;
  shpRet.ilDigi := 0;
  shpRet.ifnr := defaultIfnr;

 l_eop:
END;


{}

PROCEDURE MixPath ( VAR shPath : T_ShPath; pCB : TP_AXCB );
{* pCB in shPath reinmischen. pCBPath ist umgedreht, shPath NICHT ! *}
{* Wird bei Connects von aussen ber den Digis verwendet *}
  VAR i : WORD;
      shpZwisp : T_ShPath;
      iPath : BYTE;
BEGIN
  IF shPath.Ifnr = 0 THEN shPath.Ifnr := pCB^.Iface;
  shpZwisp := shPath;
  shPath.Digi[0] := pCB^.ToCall;
  iPath := 1;
  IF pCB^.nMyCall > 0 THEN FOR i := pCB^.nDigi DOWNTO pCB^.nMyCall DO
    BEGIN {* Sofern vorhanden, Anfang des Originalpfades kopieren. *}
    IF iPath <= nShPathDIGIS THEN shPath.Digi[ iPath ] := pCB^.Digi[i];
    Inc (iPath);
    END;
  shPath.nMyCall := iPath-1;
  IF (shpZwisp.ilDigi <> shpINVALID) AND (shpZwisp.ilDigi >=1) THEN
    FOR i := 0 TO shpZwisp.ilDigi-1 DO
      BEGIN {* Den Pfad vom Autoroter reinmischen (ohne ZielCall) *}
      IF iPath <= nShPathDIGIS THEN shPath.Digi[ iPath ] := shpZwisp.Digi[i];
      Inc (iPath);
      END;
  IF pCB^.nMyCall > 1 THEN FOR i := pCB^.nMyCall-1 DOWNTO 1 DO
    BEGIN {* und den Rest des Originalweges wieder rein (dabei das geroutete Call wegnehmen) *}
    IF iPath <= nShPathDIGIS THEN shPath.Digi[ iPath ] := pCB^.Digi[i];
    Inc (iPath);
    END;
  IF iPath <= nShPathDIGIS
    THEN BEGIN
         shPath.Digi[iPath] := pCB^.FromCall;
         shPath.ilDigi := iPath;
         END
    ELSE shPath.ilDigi := nShPathDIGIS;
END;


FUNCTION TryToConnectRoute  (pm:tp_mBuf; pCB:tp_axcb; VAR pNewCB:TP_AXCB ) : BOOLEAN;
 {* Wird aufgerufen, wenn ein Frame Rxt wurde, das uns als Digi benutzen *}
 {* will. Dabei kann es durchaus sein, dass MyCall = ToCall ist!         *}
   VAR pCBOut      : TP_AXCB;
       pShZiel     : TP_ShCall;
       shZielPath  : T_ShPath;
       i           : WORD;
       how         : T_Routing;
       ifnr        : T_IFNR;
BEGIN
  TryToConnectRoute := FALSE;
  pNewCB := NiL;

  ifnr := pCB^.iface;
  REPEAT
    IF (pCB^.nMyCall <= 1) {* 1 ist (umgedrehter Pfad !) immer der letzte Digi *}
      THEN pShZiel := @pCB^.fromCall {* ich bin selber das Ziel (Alle Digi mit gesetztem H oder gar kein Digi) *}
      ELSE pShZiel := @pCB^.digi[pCB^.nMyCall-1]; {* nchster Digi *}
    how := RouteIt ( ifnr, pShZiel, shZielPath );
    IF (how = cIFACE) AND (pCB^.nMyCall > 0) THEN
      BEGIN {* alle MYCALLS "weg"routen*}
      ifnr := shZielpath.ifnr;
      Dec (pCB^.nMyCall);
      END;
  UNTIL (how<>cIFACE) OR (pCB^.nMyCall=0);

  IF how <> cIFACE
    THEN BEGIN {* QSO ber uns. Neuen Pfad erstellen und pNewCB bauen *}
         MixPath ( shZielPath, pCB );
         CutPath ( shZielPath );
         pNewCB := TryToConnectShPath (shZielPath);
         TryToConnectRoute := (pNewCB<>NiL); {* Erfolg nur wenn QSO auch aufgebaut werden konnte *}
         END
    ELSE BEGIN
         CalcState (pCB,pm); {* QSO doch an uns! *}
         TryToConnectRoute := TRUE; {* wir beantworten das QSO *}
         END;
END;


FUNCTION UIRoute  ( VAR pCB:TP_AXCB ) : BOOLEAN;
 {* Wird aufgerufen, wenn ein UI Rxt wurde, das uns als Digi benutzen *}
 {* will. Dabei kann es durchaus sein, dass MyCall = ToCall ist ! *}
   VAR pCBOrg      : TP_AXCB;
       pShZiel     : TP_ShCall;
       shZielPath  : T_ShPath;
       i           : WORD;
       how         : T_Routing;
       ifnr        : T_IFNR;
BEGIN
  UIRoute := FALSE;
  {* Der Pfad ist umgedreht!
   * a>d via b,c
   * ist gespeichert als
   * from d  to: a digis: c,b
   *}
  ifnr := pCB^.iface;
  REPEAT
    CASE pCB^.nMyCall OF {* 1 ist (umgedrehter Pfad !) immer der letzte Digi *}
      0,1 :  pShZiel := @pCB^.fromCall; {* ich bin selber das Ziel (Alle Digi mit gesetztem H oder gar kein Digi) *}
      { 1 :  pShZiel := @pCB^.digi[1]; {* Ich bin der letzte Digi *}
      ELSE pShZiel := @pCB^.digi[pCB^.nMyCall-1]; {* Nchsten Digi routen *}
      END;
    how := RouteIt ( ifnr, pShZiel, shZielPath );
    IF (how = cIFACE) AND (pCB^.nMyCall > 0) THEN
      BEGIN {* myCall <> letzter Digi -> alle MYCALLS "weg"routen*}
      ifnr := shZielpath.ifnr;
      Dec (pCB^.nMyCall);
      END;
  UNTIL (how<>cIFACE) OR (pCB^.nMyCall=0);

  IF how <> cIFACE
    THEN BEGIN {* UI ber uns. Neuen Pfad erstellen und pNewCB bauen *}
         MixPath ( shZielPath, pCB );
         CutPath ( shZielPath );
         ShPath2PCB (shZielPath,pCB);
         UiRoute := TRUE;
         END
    ELSE BEGIN
         UIRoute := FALSE; {* wir beantworten das QSO *}
         END;
END;

{}


PROCEDURE AppendPath ( VAR shpFound : T_ShPath;
                           shpArg   : T_ShPath;
                           pCB      : TP_AXCB );
{* shPath := pCB^+shpArg+shPath. pCB-Path ist umgedreht, shPath NICHT !
 * Orginal pCB (DL7GAI,db0wst>DB0ME)
 * Connect Befehl (c DG9EP v DF1JC)
 * Etw. gefundene Route (DF1JC v db0afs)
 * kombinieren:     (DL7GAI,db0wst,db0me,db0afs,df1jc>DG9EP)
 *}
  VAR i : WORD;
      shpErg : T_ShPath;
      iPath : BYTE;
BEGIN
  IF shpFound.ifnr <> 0
     THEN shpErg.Ifnr := shpFound.ifnr
     ELSE shpErg.Ifnr := pCB^.Iface;
  shpErg.Digi[0] := pCB^.ToCall;
  iPath := 1;
  FOR i := pCB^.nDigi DOWNTO 1 DO
    BEGIN {* Der Pfad des Aufrufers *}
    IF iPath <= nShPathDIGIS THEN shpErg.Digi[ iPath ] := pCB^.Digi[i];
    Inc (iPath);
    END;
{* tja, und hier nun das Drama mit MyCall oder Ident, und wessen Interface? *}
  IF axIFace[pCB^.Iface].call <> axIFace[shpErg.Ifnr].call THEN
    BEGIN {* Wenn IFaceNamen von reingehendem und rausgehenden  *}
          {* unterschiedlich sind, dann beide innen Pfad *}
    IF iPath <= nShPathDIGIS THEN shpErg.Digi[iPath] := axIFace[pCB^.Iface].call;
    Inc (iPath);
    END;

{$IFDEF HostMode} {test 17.8.97}
  {* Evtl. kommt auch noch das IFace-Call rein *}
  IF NOT CmpShCall ( axIFace[shpErg.Ifnr].call , shpErg.Digi[iPath-1] )
    THEN BEGIN
{$ENDIF}
         {* und das IFACE-Call ist dann auch dass mit Heard-Bit *}
         shpErg.nMyCall := iPath;
         shpErg.Digi[iPath] := axIFace[shpErg.Ifnr].call;
         Inc (iPath);
{$IFDEF HostMode} {test 17.8.97}
         END
    ELSE BEGIN
         {* Ansonsten ist Heard-Bit (hoffentlich) das vorherige Call *}
         shpErg.nMyCall := iPath-1;
         END;
{$ENDIF}

  IF shpFound.ilDigi <> shpINVALID THEN FOR i := 0 TO shpFound.ilDigi DO
    BEGIN {* Der gefundene Weg *}
    IF iPath <= nShPathDIGIS THEN shpErg.Digi[ iPath ] := shpFound.Digi[i];
    Inc (iPath);
    END;
  IF shpArg.ilDigi <> shpINVALID THEN FOR i := 1 TO shpArg.ilDigi DO
    BEGIN {* und der restliche Weg, wie eingegeben (ohne geroutetes Call) *}
    IF iPath <= nShPathDIGIS THEN shpErg.Digi[ iPath ] := shpArg.Digi[i];
    Inc (iPath);
    END;
  IF iPath <= nShPathDIGIS THEN shpErg.ilDigi := iPath-1
                           ELSE shpErg.ilDigi := nShPathDIGIS;
  shpFound := shpErg;
END;


FUNCTION SearchForPath  (shpArg : T_ShPath;
                            pCB : tp_axcb;
                      DoConnect : T_DoConnect;
                       VAR sRet : STRING;
                     VAR pCBRet : tp_axcb) : BOOLEAN;
  VAR pShZiel : TP_ShCall;
      shpFound : T_ShPath;
      ifnr,nSuch : BYTE;
      how : T_Routing;
BEGIN
  SearchForPath := FALSE;
  pCBRet := NiL;
  ifnr := pCB^.aktifnr;
  nSuch := 0;
  REPEAT
    pShZiel := @shpArg.Digi[nSuch];  {* hier steht immer das Call drin, das soll ja gesucht weren... *}
    how := RouteIt (ifnr, pShZiel, shpFound);  {* is shpFound wird der Weg nach pShZiel^ zurckgegeben *}
    IF (how = cIFACE) AND (nSuch < shpFound.ilDigi) AND (shpFound.ilDigi<>shpINVALID) THEN
      BEGIN {* myCall <> letzter Digi *}
      ifnr := shpFound.ifnr;
      Inc (nSuch);
      END;
  UNTIL (how<>cIFACE) OR (nSuch > shpFound.ilDigi) OR (shpFound.ilDigi=shpINVALID);

  IF (how = cIFACE) AND (nSuch = shpArg.ilDigi)
    THEN BEGIN {* interner Connect, da alle eingegebene Digis und das Ziel MyCalls sind *}
         sRet := 'internal loopback'+EOL+
             '*** connected to '+f_sh2Asc(pShZiel^);
         pCB^.aktIfnr := shpFound.ifnr;
         SearchForPath := TRUE;
         END
    ELSE BEGIN  {* QSO ber uns. Neuen Pfad erstellen und pNewCB bauen *}
         AppendPath (shpFound,shpArg,pCB); {* und hier wird es in den Ursprungspfad gemischt *}
         CutPath (shpFound);
         ShPath2String ( shpFound, shpFound.nMyCall, shpFound.ilDigi-1, TRUE{MitPort}, sRet );
         IF DoConnect = cCONNECT THEN pCBRet := TryToConnectShPath (shpFound); {* und der Connect wird gemacht *}
         SearchForPath := (pCBRet<>NiL);
         END;
END;

{}

FUNCTION GetIfnr4zielMH ( ziel : T_shCall; VAR via : STRING ) : t_ifNR;
 {* gibt die ifnr zurck, ber die ziel zuletzt gehrt wurde. *}
 {* Wenn nicht, wird ein DEFAULT wert zurckgegeben           *}
  VAR n : WORD;
      p : POINTER;
      i : WORD;
      s : STRING;
BEGIN
  p := @ziel;
  n := 1;
  WHILE ( n<=nmHeard ) AND
	(NOT MemEq (p, @pmHeard^[n].Call, Sizeof (t_shCall)-1)) DO
	Inc (n);

  {* pmHeard^ ist nicht sinnvoll, wenn er ueber einen NET/ROM Interlink kam, *}
  {* denn NET/ROM ist nicht Adresstransparent                                *}
  IF n <= nmHeard THEN {* ein Kanidat ist gefunden... *}
    IF pmHeard^[n].nDigi = 0 THEN {*..der direkt gehrt wurde... *}
      IF axIFace[pmHeard^[n].ifnr].art = aINTERLINK THEN {*..auf einem Interlink ! *}
	n := nmHeard+1; {* ne den wollen wir nicht *}

  IF n <= nmHeard
    THEN BEGIN
	 s := '';
	 FOR i := pmHeard^[n].nDigi DOWNTO 1 DO {** Umdrehen der Liste ! **}
	   s := s + f_sh2asc ( pmHeard^[n].Digi[i] ) + ',';
	 IF s > '' THEN Dec ( byte(s[0]) );
	 IF (via = '')	THEN via := s
			ELSE IF s <> '' THEN via := s + ',' + via;
	 GetIfnr4zielMH := pmHeard^[n].ifnr;
	 END
    ELSE GetIfnr4zielMH := 0;
END;

{}

FUNCTION  Getifnr4zielFromIFaceNAME( ziel : T_shCall; VAR via : STRING ) : t_ifNR;
{* Schaut nach, ob ZIEL ein IFACE-Call ist *}
  VAR n : WORD;
      p : POINTER;
      found : BOOLEAN;
BEGIN
  WatchDog;
  p := @ziel; {* Wird zweimal verwendet! *}
  n := 1; found := FALSE;

  WHILE ( n<=MAX_iface ) AND (Not found) DO
    BEGIN
      IF  ( NOT MemEq (p, @axIFace[n].Call, Sizeof(axIFace[1].Call)-1))
       OR ( NOT axIFace[n].valid )
       OR ( axIFace[n].MinSSID <> ( (by1Array(p^)[7] DIV 2) AND 15 ) )
	  THEN INC (n)
          ELSE found := TRUE;
    END;

  IF found THEN BEGIN {* It's a mad mad mad mad World ! *}
 	        Getifnr4zielFromIFaceNAME := n;
		       n := pos (',',via);
		       IF n = 0 THEN n := pos (' ',via);
		       IF n = 0 THEN n := length (via);
		       Delete (via,1,n );
		END
	   ELSE Getifnr4zielFromifaceNAME := 0;
END;

{}

FUNCTION Getifnr4Flexnet ( shZiel : T_shCall; VAR via : STRING; VAR lz : T_lz ) : t_ifNR;
  LABEL l_EoP;
  VAR n : WORD;
      zi,bi : INTEGER;
      sl  : STRING;
BEGIN
  Getifnr4Flexnet := 0;
  lz := 0;
  IF NOT useFlexNet THEN Exit;
  {* Sucht in der ZielTabelle, kehrt mit positivem Index zurck, wenn ok *}
  zi := FlexSucheZiel ( shZiel, ( byte(shZiel[7])  AND 30 ) SHR 1, FALSE);
  {* FALSE= SSID muss nicht GENAU uebereinstimmen, sondern nur in den Bereich passen *}
  IF zi <= 0 THEN GOTO l_EoP; {* Ziel nicht bekannt *}

  {* Stelle nun den Weg zusammen *}
  bi := paZiel^[zi].lkUsed;
  IF bi = 0 THEN GOTO l_EoP; {* keine Route *}
  lz := paZiel^[zi].lz[bi];
  n := bi;  {* NachbarIndex *}
  AR_GlobReturn := n;
  {* FALL 1: xyz v ME-5,ME-1,BM
   * FALL 2: BM v  ME-5,ME-1
   * FALL 3: xyz   ziel ist direkter Linkpartner
   *}
  IF link[n].direkt
    THEN sl := ''  {* Der gesuchte Nachbar ist als direkt erreichbar in der
		   * Linkliste gekennzeichnet - also brauche wir
		   * kein via zu Ihm zu basteln *}
    ELSE sl:= LinkPort2Via (n, cNORMAL);
  {* FALL 1: sl = ME-5,ME-1
   * FALL 2: sl = ME-5,ME-1
   * FALL 3: sl = ''
   *}
  IF NOT CmpShCall(shZiel,link[n].call)
    THEN BEGIN
	 IF sl <> '' THEN sl := sl + ',' ;
	 sl := sl + f_sh2Asc(link[n].call);
	 END
    ELSE AR_GlobReturn:= 0;  {* doch nicht... ble Methose $TODO... *}
  {* FALL 1: sl = ME-5,ME-1,BM
   * FALL 2: sl = ME-5,ME-1
   * FALL 3: sl = ''
   *}
  IF sl <> '' THEN
    IF via <> '' THEN sl := sl + ',';
  via := sl + via;

  Getifnr4Flexnet := LinkPort2IfNr ( n );
  l_EoP:
END;



FUNCTION Getifnr4LinkListe ( ziel : T_shCall; VAR via : STRING; VAR lz : T_lz ) : t_ifNR;
  VAR n : WORD;
      p : POINTER;
      s : STRING;
{* gibt die ifnr zurck, ber die ziel laut Linkliste erreicht werden kann. *}
{* Wenn nicht, wird ein DEFAULT wert zurckgegeben *}
BEGIN
  lz := 0;
  p := @ziel;
  n := 1 ;
  WHILE ( n<=nLinks ) AND
	( NOT CmpShCallSSID (p, @Link[n].Call)
	      OR
	  NOT Link[n].Valid
	) DO Inc (n);

  IF n <= nLinks THEN BEGIN  {* gefunden *}
		      lz := link[n].tSchnitt;
		      IF link[n].direkt
			THEN  {* Der gesuchte ist als direkt erreichbar in der
			       * Linkliste gekennzeichnet - also brauche wir
			       * kein via zu basteln *}
			ELSE BEGIN
			     s := LinkPort2Via (n,cNORMAL);
			     IF via = '' THEN via := s
					 ELSE via := s + ',' + via;
			     END;
		      Getifnr4LinkListe := LinkPort2IfNr ( n )
		      END
		 ELSE Getifnr4LinkListe := 0;
END;


{}

FUNCTION AR_SearchRoute ( ziel : T_shCall;
                          ZielEqTo : BOOLEAN;
                      VAR ifnr : T_Ifnr;
                      VAR via : STRING ) : T_LZ;
{* Gibt die ifnr zurck, ber die Ziel am wahrscheinlichsten erreicht
 * werden kann. Wenn nicht, bleiben IFNR und VIA unverndert. *}
 VAR ifZwisp : T_IfNr;
     lz : T_LZ;
BEGIN
  WatchDog;
  lz := 0; AR_GlobReturn := 0; AR_ZielEqTO := ZielEqTo;

  ifZwisp := Getifnr4zielFromifaceNAME ( ziel, via );
  {$IFDEF coverIF} IF ifZwisp <> 0 THEN IF hw[ifZwisp].cDrv = drvLOOPBACK THEN ifZwisp := 0; {$ENDIF}

  {* Flexnet hat Vorang vor Linktabelle, da alle LZ-Messungen der
   * Linktabelle (auch dumme) in den FlexRouter eingetragen werden.
   * Ausserdem ist sonst das ausnutzen einer schnelleren Umwegverbindung
   * nicht mglich *}
  IF ifZwisp = 0 THEN ifZwisp := Getifnr4Flexnet ( ziel, via, lz );
  {$IFDEF coverIF} IF ifZwisp <> 0 THEN IF hw[ifZwisp].cDrv = drvLOOPBACK THEN ifZwisp := 0; {$ENDIF}

  IF ifZwisp = 0 THEN ifZwisp := Getifnr4LinkListe ( ziel, via, lz );
  {$IFDEF coverIF} IF ifZwisp <> 0 THEN IF hw[ifZwisp].cDrv = drvLOOPBACK THEN ifZwisp := 0; {$ENDIF}

   IF ifZwisp = 0 THEN ifZwisp := GetIfnr4zielMH ( ziel, via );
  {$IFDEF coverIF} IF ifZwisp <> 0 THEN IF hw[ifZwisp].cDrv = drvLOOPBACK THEN ifZwisp := 0; {$ENDIF}

  IF ifZwisp = 0 THEN BEGIN {* letzte Mglichkeit: suche den Weg ohne SSID *}
		      StripShSSID (ziel);
		      ifZwisp :=  Getifnr4LinkListe ( ziel, via, lz);
		      END;
  {$IFDEF coverIF} IF ifZwisp <> 0 THEN IF hw[ifZwisp].cDrv = drvLOOPBACK THEN ifZwisp := 0; {$ENDIF}

  {* if ifnr = 0 THEN LookNETROM  *}

  IF ifZwisp <> 0 THEN ifNr := ifZwisp;
  AR_SearchRoute := lz;
END;


END.
