{$I FD_INCL.PAS}
UNIT FD_ALDE;

{* Application Level Data Exchange  (fr Anschluss von WX etc.)
 * Speichert alles was an Paketen von der Unterschicht kommt....
 * Wird z.Zt. nur in Verbindung mit dem KISS Treiber verwendet
 *}

INTERFACE

USES FD_Def;

PROCEDURE ALDEList(pcb: TP_AXCB);

{}

IMPLEMENTATION

USES FD_Div,
     FD_Subr,
     FD_Sysop,  { DoBind() }
     FD_Mem,
     FD_Tx { TX_info };

CONST csMyName = 'ALDE';

CONST cMAXMAX=15;
TYPE T_STORE = STRING;
     TP_STORE = ^T_STORE;
     T_AP_STORE = ARRAY [1..cMAXMAX] OF TP_STORE;
     T_ALDE = RECORD
       valid : BOOLEAN;
       bindnr : WORD;
       fLogTransfer : BOOLEAN;
       nStartTransfer, {* Wenn soviele Pakete angekommen sind, dann starte LogTransfer *}
       nStore : WORD; {* Soviele Pakete sollen lokal gespeichert werden *}
       apStore : T_AP_STORE;
       indWrite : WORD;
     END;
CONST MAX_ALDE = 1;
VAR ALDE : ARRAY [1..MAX_ALDE] OF T_ALDE;

{}



PROCEDURE ALDE_RXPacketUp (pm:tp_mBuf);
{* Wird von untenliegenden Schichten aufgerufen
 * pm muss beizeiten durch einen Aufruf von FD_AXCB.ReleaseL1Rxbuf(pm:tp_mbuf)
 * wirder an den Pool zurckgegeben werden.
 *}
BEGIN
  IF pm^.inUse>255 THEN Exit; {* Mehr knnen wir nicht *}

  WITH alde[1] DO
    BEGIN
    IF apstore[indWrite] <> nil THEN
      BEGIN {* alten Inhalt freigeben *}
      MemFree( pointer(apStore[indWrite]) , 1+byte(apStore[indWrite]^[0])  );
      END;
    {* Speicher fr neuen Eintrag holen *}
    MemGet( pointer(apStore[indWrite]), pm^.inUse+1 );
    Move ( pm^.pData,  apStore[indWrite]^[1],  pm^.inUse );
    byte( apStore[indWrite]^[0] ) := lo(pm^.inUse);
    Inc(indWrite);
    IF indWrite>nStore THEN indWrite := 1;
    END;
  ReleaseL1Rxbuf(pm);
END;


PROCEDURE ALDEList(pcb: TP_AXCB);
  VAR i,n : WORD;
BEGIN
WITH alde[1] DO
  BEGIN
  IF not VALID then Exit;
  i := indWrite+1;
  FOR n := 1 TO nStore DO
    BEGIN
    IF i<1 THEN i := nStore;
    IF apStore[i] <> nil THEN
        TX_Info(pCB,SPAETER, EOL + fStr(n)+'. '+fStr(i)+'. '+apStore[i]^);
    Dec(i); {* Runterzhlen, das neueste zuerst/oben *}
    END;
  END;
END;




PROCEDURE Init_ALDE;
  {* IFACE mit Default Werten versorgen *}
  VAR j : WORD;
BEGIN
  FillChar( alde, sizeof(alde), #0 );
  FOR j := 1 TO MAX_ALDE DO WITH ALDE[j] DO
    BEGIN
    valid := FALSE;
    fLogTransfer := false;
    nStartTransfer := 0;
    nStore := 10;
    indWrite := 1;
    END;
END;



{---------------------------------------------------------------------}

PROCEDURE Kommandozeile(VAR sArg : STRING; devNr : BYTE);
  CONST COMANDS1 =
{ 1}  'INIT BIND ';
       cmINIT=1; cmBIND=2;

  CONST cmdTab1: ARRAY [1..length(COMANDS1)] OF CHAR = COMANDS1;
  VAR   lDevNrDn,para : Longint;
        sZwisp : STRING;
        sDn : STRING;
        p : POINTER;
        x : BYTE;
BEGIN
WITH ALDE[devNr] DO
  REPEAT
    x := ScanStr (sArg, @cmdTab1, sizeOf (cmdTab1));
    para := ScanforNum(sArg); {* Wenn keine Zahl, wird ein sehr hoher Wert verwendet *}
    CASE x OF
      cmINIT : ;{axIFace[devnr].valid :=  true;}
      cmBIND : BEGIN  { BIND kiss 3 }
               ScanForText (sArg, sDn );
               ldevNrDn := ScanforNum(sArg);
               bindnr := DoBind( csMyName,devnr, sDn, ldevNrDn );
               IF bindnr > 0 THEN
                 BEGIN
                 {* Hole die SendeRoutine *}
                 p := Pointer( Register[bind[bindnr].regNrDn].procSetPara (
                      bind[bindnr].devNrdn, spHOLEPROC, ord(hpTxPacket) )
                 );
                 axIFace[devnr].procTxPacket := TFN_TxPacket(p);
                 {* Der Hardware noch meine Nummer mitteilen *}
                 IF DoDnSetPara(bindnr, spSETZEWertIFACENr, devNr) = 0 THEN;;;
                 {* und noch eben speichern des Protokollnamens (nur so) *}
                 {sNameDn := sDn; devNrDn := devNr;}
                 valid := true;
                 END;
               END;

          ELSE BEGIN
               END
      END;
  UNTIL x = 0;
END;


{$F+}
FUNCTION ALDE_SetPara ( devnr : BYTE; what:T_setPara; wert:longint):LONGINT;
  TYPE T_PSTRING = ^STRING;
  VAR pm : TP_MBUF;
      s : STRING;
BEGIN
WITH alde[devnr] DO
  BEGIN
  ALDE_SetPara := speOK;
  CASE what OF
    spKOMMANDOZEILE
      : BEGIN
        Kommandozeile( T_PSTRING(wert)^, devnr );
        Exit;
        END;
    spHOLEPARAMSTRING
      : BEGIN
        sGlobReturn := fStr(alde[1].nStore)
                    + ' logTr:'  + F_Bool2OnOff(fLogTransfer)
                    + ' startTr:'+ fStr(nStartTransfer)
                    + ' indWrt:' + fStr(indWrite);
        ALDE_SetPara := Longint(@sGlobReturn);
        END;

    spHoleVAL
      : IF wert = ord(hvBINDNR) THEN ALDE_SetPara := bindNr;

    spHoleProc
      : BEGIN
        IF wert= Ord(hpRXPacketUp) THEN ALDE_SetPara := LongInt(@ALDE_RXPacketUp);
        END;

    ELSE {* case *} ALDE_SetPara := speNNCMD;
  END;
 END;
END;


BEGIN
  Init_ALDE;
  DoRegister(csMyName, 1,MAX_ALDE, ALDE_SetPara);
END.
