;***************************************************
;* Datenstrukturen fr Falcon Level 2 und Firmware *
;***************************************************
TRUE      equ     1                         ;wie in PASCAL
FALSE     equ     0                         ;wie in PASCAL

L2MFLEN   equ     328                       ;Level 2 max. Framelnge

ZUST_NOP  equ     0                         ;Zustand Kanal inaktiv
ZUST_DCD  equ     1                         ;DCD ist an
ZUST_DWAIT equ    2                         ;DWAIT luft
ZUST_FREE equ     3                         ;Frei fr Start
ZUST_TXD  equ     4                         ;TXD aktiv
ZUST_DAT  equ     5                         ;Daten werden gesendet

DUP_MODE  equ     0                         ;Modus Vollduplex
SIMP_MODE equ     1                         ;Modus normales Simplex
SPEC_SIMP equ     2                         ;Simplex mit Switch
;* externe Header Definition der Control Blcke (in DigiWare: T_mBuf)

mbuf         struc
next         dd      ?                      ;Zeiger auf nchstes Element
buf          dd      ?                      ;Zeiger auf Daten Segment:Offset
bufl         dd      ?                      ;20 Bit Adresse ohne Segment
InUse        dw      ?                      ;Lnge der Daten
time         dd      ?                      ;aktuelle Zeit in 10ms
ifnr         db      ?                      ;Nummer des Interfaces 1..4
txed         db      ?                      ;Frame wurde gesendet
pbEnabled    dd      ?                      ;Zeiger auf Timer ??
discard      db      ?                      ;boolsch TRUE wenn weggeworfen
nMyCall      db      ?                      ;hier: Debugzaehler
nHeard	     db      ?                      ;hier: Debugzaehler
mbuf         ends

;* Definitionen fr SCC-Ports
liste     struc                             ;Listenstruktur
hd        dd       ?                        ;Anfang
tl        dd       ?                        ;Ende
          ends

sccdef    struc
prtnr     db       ?                        ;Portnummer Bereich 0..3
baud      dd       ?                        ;eingestellte Baudrate
duplex    db       ?                        ;0 = Duplex, 1 = Simplex ohne Switch
                                            ;2 = Simplex mit Switch
txd       dw       ?                        ;TXD in * 10 ms
pers      db       ?                        ;Persistence
slot      dw       ?                        ;Slottime + DWAIT * 10 ms
clk_reg   db       ?                        ;Register 11 Modus
nrzi_mode db       ?                        ;0 = NRZ, 1 = NRZI
chk_crc   db       ?                        ;CRC zum Prfen der obigen Parameter
;* ab hier kommen nur noch nicht festgelegte Variablen
l1_state  db       ?                        ;Zustand L1
          ;0 = inaktiv (oder CRC falsch)
          ;1 = RX ein, DCD ein
          ;2 = RX ein, DCD aus (z.B. DWAIT)
          ;3 = TX ein, TXD aktiv
          ;4 = TX ein, Daten werden gesendet
          ;5 = TX-Tail
fak_rx    dw       ?                        ;RX-Baudfaktor
fak_tx    dw       ?                        ;TX-Baudfaktor
wr5_rx    db       ?                        ;WR5 Mode RX
wr5_tx    db       ?                        ;WR5 Mode TX
wr15_rx   db       ?                        ;WR15 Mode RX
wr15_tx   db       ?                        ;WR15 Mode TX
rd0_scr   db       ?                        ;alter Register 0 Zustand
rxakt     dd       ?                        ;aktuelles RX-Element
rxadr_low dw       ?                        ;aktuelle RX-Adresse Low Word
rxadr_hi  db       ?                        ;aktuelle RX-Adresse High Byte
txqueue   liste    ?                        ;aktuelle TX-Liste
chan_time dw       ?                        ;Timervariable des Kanals
ch_free   db       ?                        ;Kanal ist belegt, wenn FALSE
dummy     db  (173-ch_free-1) dup (?)
          ends


           .data
           extrn  fasttick:dword
           extrn  l2_parms
l2_parms0  equ    l2_parms+0
l2_parms1  equ    l2_parms+ 1 * size sccdef
l2_parms2  equ    l2_parms+ 2 * size sccdef
l2_parms3  equ    l2_parms+ 3 * size sccdef
l2_parmse  equ    l2_parms+ 4 * size sccdef ;zum Berechnen der Lnge
           extrn  stfl:liste                ;gelscht Liste Sender
           extrn  rxfl:liste                ;Empfangsliste
           extrn  freel:liste               ;Freiliste
           extrn  constFOREVER_TRUE:byte    ;zum Umlegen der Zeiger
           extrn  nFreeBuffer:word          ;aktueller Stand freien Buffer
           extrn  nMinFreeBuffer:word       ;minimaler Stand freien Buffer
           extrn  nNoBuffer:word            ;Fehlerzhler


;l2_parms   label  word                      ;Anfang Parameter
;l2_parms0  sccdef <>                        ;Parameter Level 2 Kanal 0
;l2_parms1  sccdef <>                        ;Parameter Level 2 Kanal 1
;l2_parms2  sccdef <>                        ;Parameter Level 2 Kanal 2
;l2_parms3  sccdef <>                        ;Parameter Level 2 Kanal 3
;l2_parmse  label  word