;**************************************************************
;* Assemblermodul zur Ansteurung der ISCC-Ports auf Falcon25. *
;* DIGIware-Level1					      *
;* Untersttzt wird das Modell Turbo-Pascal.		      *
;* ISCC 1 und 2 Register-Bank 2 Context Switch		      *
;**************************************************************

	     .186			    ;fr 186er Prozessor
	     locals			    ;lokale Labels erlauben
	     warn			    ;Warnungen ein
	     .model tpascal
	     include  falcl1.inc	    ;Pufferdefinitionen Level 1/2
	     include  v25ports.inc	    ;V25-Ports
	     include  sccdefs.inc	    ;SCC-Ports
NEUER equ 0                         ;nderungen aus FALCL1 ...25.11.92


	     public   scc_first 	    ;einmalige Init-Funktion
	     public   scc_timer 	    ;10 ms Timer Funktion

	     .data			    ;_BSS Segment uninitialisiert
bnk2_stk     dw    64 dup (?)		    ;Stack fr Registerbank 2
bnk2_stkend  label word 		    ;Ende des Stacks
	     .code
	     jumps			    ;Sprnge optimieren

;***************
;* Kanalmacros *
;***************
;***************************************************************
;* Timerfunktion der einzelnen Kanle.			       *
;* Control zeigt auf den Level 2 Controlblock		       *
;***************************************************************
timefunk     macro  CHAN,Control,SDLC,DMA
	     local  @@dcd_isok,timefunk_ex,no_dwait,is_dup,@@test,is_txd,@@start_tx,@@no_cts
             local  @@AgainDuplex

	     mov    ax,word ptr DATA:[Control.chan_time] ;Zeitzhler lesen
	     or     ax,ax		    ;keine Aktion ?
	     jz     timefunk_ex 	    ;genau so ists
	     dec    ax			    ;erniedrigen
	     mov    word ptr DATA:[Control.chan_time],ax ;Zeitzhler setzen
	     jnz    timefunk_ex 	    ;noch nix zu tun
	     mov    al,byte ptr DATA:[Control.l1_state] ;Zustand holen
	     cmp    al,ZUST_DWAIT	    ;kleiner als Zustand DWAIT ?
	     jb     timefunk_ex 	    ;ja Ende
	     cmp    al,ZUST_TXD 	    ;war TXD ?
	     je     is_txd		    ;ja bereits bei TXD
	     ja     timefunk_ex 	    ;nein schon weiter -> Ende (ZUST_DAT)
	     ;* also hier ZUST_FREE oder ZUST_DWAIT (mit abgel. Timer)
	     ;* DWAIT ist abgelaufen, Persistence checken
	     ;* und gegebenenfalls Sender auftasten, wenn noch
	     ;* Frames im Puffer sind.
	     mov    byte ptr DATA:[Control.l1_state],ZUST_FREE ;bereit zum Senden
	     mov    byte ptr DATA:[Control.chan_time],1 ;Timer setzen
	     les    si,dword ptr DATA:[Control.txqueue.hd] ;Anfang der Kette holen
	     mov    ax,es		    ;Segment
	     or     ax,si		    ;+ Offset 0 ?
	     jz     timefunk_ex 	    ;ja nix drin -> Ende
	     ;* hier angekommen ist nun der Sender einzuschalten
	     ;* und das TXD abzuwarten
	     ;* wenn TXD auf 0 steht, wird das Senden durch
	     ;* CTS gestartet !
	     ;* Die DMA wird bereits initialisiert !
	     mov   bl,byte ptr DATA:[Control.duplex] ;Mode holen
	     cmp   bl,DUP_MODE		    ;Duplex Mode ?
	     _cli			    ;Interrupts temporr sperren
	     je    short is_dup 	    ;ja RX bleibt an
             ; DCD nochmals testen.
	     in    al,[SDLC+RD0]	    ;Status lesen
	     test  al,08h		    ;DCD an ?
	     jz    short @@dcd_isok	    ;nein
	     mov   byte ptr [Control.ch_free],FALSE ;Kanal ist belegt
	     mov   byte ptr DATA:[CONTROL.l1_state],ZUST_DCD ;DCD ist ja an
	     or    byte ptr DATA:[CONTROL.rd0_scr],08h ;auch merken
	     _sti			    ;Interrupts wieder zulassen
	     jmp   short timefunk_ex	    ;ja DCD an -> Fehler
					    ; (hier stand bis zum 19.10.92 ein JZ !)
@@dcd_isok:
if NEUER eq 1
             mov   al,byte ptr DATA:[Control.wr15_tx] ;TX-IE Register
	     out   [SDLC+WR15],al           ;setzen (wegen DCD,CTS..)
	     mov   al,WR3_MODE              ;Modus Empfnger
	     out   [SDLC+WR3],al            ;aus
endif
             xor   ax,ax		    ;Empfangs-DMA
if (CHAN and 1) eq 0
	     out   [DMA+RDCRA0],ax	    ;abbrechen
else
	     out   [DMA+RDCRB0],ax	    ;abbrechen
endif
	     mov   ax,word ptr DATA:[Control.fak_tx] ;TX-Faktor holen
	     out   [SDLC+WR12],al	    ;Low Byte
	     mov   al,ah		    ;und
	     out   [SDLC+WR13],al	    ;High Byte umschalten

is_dup:      _sti			    ;erstmal wieder freigeben
	     les   si,dword ptr DATA:[Control.txqueue.hd] ;Anfang der Kette holen
	     mov   ax,word ptr es:[si.bufl+0];untere 16 Bit
if (CHAN and 1) eq 0
	     out   [DMA+TDARA0],ax	    ;Low Word der Adresse ausgeben
else
	     out   [DMA+TDARB0],ax	    ;Low Word der Adresse ausgeben
endif
	     mov   al,byte ptr es:[si.bufl+2];obere 16 Bit
if (CHAN and 1) eq 0
	     out   [DMA+TDARA0+2],al	    ;High Byte der Adresse ausgeben
else
	     out   [DMA+TDARB0+2],al	    ;High Byte der Adresse ausgeben
endif
;
	     mov   ax,word ptr es:[si.inUse] ;Anzahl holen
;
if (CHAN and 1) eq 0
	     out   [DMA+TDCRA0],ax	    ;Anzahl ausgeben
else
	     out   [DMA+TDCRB0],ax	    ;Anzahl ausgeben
endif
	     _cli			    ;wieder keine Interrupts
if NEUER eq 0
	     mov   al,byte ptr DATA:[Control.wr15_tx] ;TX-IE Register
	     out   [SDLC+WR15],al	    ;setzen (wegen DCD,CTS..)
endif
	     mov   cx,word ptr DATA:[Control.txd] ;TXD holen
	     mov   word ptr DATA:[Control.chan_time],cx ;und setzen
	     mov   al,byte ptr DATA:[Control.wr5_tx] ;Modus Register 5
	     or    al,69h		    ;Parameter auer RTS und CTS
	     out   [SDLC+WR5],al	    ;setzen (= PTT an)
	     mov   byte ptr DATA:[Control.l1_state],ZUST_TXD ;wir sind im TXD

	     mov   bl,byte ptr DATA:[Control.duplex] ;Mode holen
	     cmp   bl,DUP_MODE		    ;Duplex Mode ?
             je    short @@AgainDuplex
	     mov   byte ptr [Control.ch_free],FALSE ;Kanal ist belegt

@@AgainDuplex: mov   al,80h		    ;Reset TX CRC
	     out   [SDLC+WR0],al	    ;ausgeben
	     or    cx,cx		    ;CTS gesteuert ?
	     jnz   short @@no_cts	    ;nein normal weiter
	     in    al,[SDLC+RD0]	    ;Status holen
	     test  al,20h		    ;CTS ein ?
	     jnz   short @@start_tx	    ;ja TX starten
@@no_cts:    _sti			    ;Interrupts wieder freigeben
	     jmp   short timefunk_ex	    ;und Ende
is_txd:      ;* TXD ist abgelaufen.
	     ;* Mit dem Senden der Daten beginnen.
	     _cli			    ;wegen TX/EOF
@@start_tx:
if (CHAN and 1) eq 0
	     mov   al,0C0h		    ;Enable TX-A DMA
else
	     mov   al,080h		    ;Enable TX-B DMA
endif
	     out   [DMA+CCAR],al	    ;DMA starten
	     mov   al,0C0h		    ;Reset Underrun Latch
	     nop			    ;warten auf Transfer
	     out   [SDLC+WR0],al	    ;und Reset TX/EOF
	     mov   byte ptr DATA:[Control.l1_state],ZUST_DAT ;Daten senden
	     _sti			    ;wieder zulassen
timefunk_ex:
	     endm

;******************************************
;* Interrupt on external Condition	  *
;* Aufruf: SDLC Basisadresse des SCC Ports*
;*	   DMA	Basisadresse der DMA	  *
;*	   CONTROL Adresse des Ctr.Blk	  *
;*	   CHAN Kanalnummer 0-3 	  *
;******************************************
ext_int      macro CHAN,CONTROL,SDLC,DMA
	     assume ds:DATA
	     in    al,[SDLC+RD0]	    ;Status holen
	     mov   bl,al		    ;und merken (bl = neuer Status)
	     mov   al,10h		    ;Reset External Status
	     out   [SDLC+WR0],al	    ;ausgeben
	     mov   bh,bl		    ;Status nach bh
	     xor   bh,byte ptr DATA:[CONTROL.rd0_scr];bh = nderung des Status
	     mov   byte ptr DATA:[CONTROL.rd0_scr],bl;Status merken

;	     hier Test auf innerhalb TX-Underrun/EOM Interrupt
;	     Ist im Zustand ZUST_DAT die DMA nicht abgelaufen, gab es einen
;	     Underrun. (Das sollte nicht vorkommen)
	     cmp   byte ptr DATA:[CONTROL.l1_state],ZUST_DAT ;End of Frame ??
	     jb    @@dcd_check		    ;irgendwas unterhalb
	     test  bl,40h		    ;Bit 6 = Tx Underrun/EOM
	     jz    @@dcd_check		    ;kein Underrun
	     les   si,dword ptr [CONTROL.txqueue.hd] ;Zeiger Sendeblock
	     mov   ax,es		    ;Test auf
	     or    ax,si		    ;Null Pointer
	     jnz   short @@new_frame	    ;weitere Frames folgen
	     ;** hier ist TxTail abgelaufen (gibt keinen extra zustand fr !)
	     mov   al,18h		    ;Abort     dg3dbi 15.10.92
	     out   [SDLC+WR0],al	    ;senden !  dg3dbi 15.10.92
	     mov   al,byte ptr DATA:[CONTROL.wr5_rx] ;Modus Sender aus
	     out   [SDLC+WR5],al	    ;an ISCC
	     cmp   byte ptr DATA:[CONTROL.duplex],SPEC_SIMP ;Spezial Simplex ??
	     jne   short @@no_ssimp	    ;nein
	     mov   ax,word ptr DATA:[CONTROL.fak_rx];RX Faktor holen
	     out   [SDLC+WR12],al	    ;Low Byte
	     mov   al,ah		    ;und
	     out   [SDLC+WR13],al	    ;High Byte umschalten
@@no_ssimp:  mov   al,WR3_MODE+RX_ENABLE    ;Modus Empfnger
	     out   [SDLC+WR3],al	    ;ein
if NEUER eq 1
   	     mov   al,byte ptr DGROUP:[CONTROL.wr15_rx];Interruptzustand
             out   [SDLC+WR15],al	    ;neu setzen
endif
	     mov   byte ptr DATA:[CONTROL.l1_state],ZUST_DWAIT ;ISCC erstmal abwarten
	     mov   byte ptr [Control.ch_free],TRUE ;Kanal ist frei
	     cmp   byte ptr DATA:[CONTROL.duplex],DUP_MODE ;Vollduplex ??
	     je    @@dcd_check		    ;ja nichts weiter tun
	     mov   ax,word ptr DATA:[CONTROL.rxadr_low] ;untere 16 Bit Adresse
if (CHAN and 1) eq 0
	     out   [DMA+RDARA0],ax	    ;Low Word Anfang -> DMA
else
	     out   [DMA+RDARB0],ax	    ;Low Word Anfang -> DMA
endif
	     mov   al,byte ptr DATA:[CONTROL.rxadr_hi] ;obere 4 Bit Adresse
if (CHAN and 1) eq 0
	     out   [DMA+RDARA0+2],al	    ;Low Word Anfang -> DMA
else
	     out   [DMA+RDARB0+2],al	    ;Low Word Anfang -> DMA
endif
	     mov   ax,L2MFLEN+3 	    ;DMA Lnge
if (CHAN and 1) eq 0
	     out   [DMA+RDCRA0],ax	    ;ausgeben
	     mov   al,0E0h		    ;Startkommando A
else
	     out   [DMA+RDCRB0],ax	    ;ausgeben
	     mov   al,0A0h		    ;Startkommando B
endif
	     out   [DMA+CCAR],al	    ;ausgeben
	     cmp   byte ptr DATA:[CONTROL.duplex],DUP_MODE ;Duplex ?
	     je    short @@is_duplex	    ;ja
	     mov   byte ptr [Control.ch_free],FALSE ;Kanal ist belegt
	     mov   byte ptr DATA:[CONTROL.l1_state],ZUST_DCD ;falls DCD an
	     test  bl,08h		    ;DCD an ??
	     jnz   @@dcd_check		    ;ja
	     mov   byte ptr DATA:[CONTROL.l1_state],ZUST_DWAIT ;DWAIT Zustand
	     mov   byte ptr [Control.ch_free],TRUE ;Kanal ist frei
	     mov   ax,word ptr DATA:[CONTROL.slot] ;Wartekonstante (DWAIT)
	     mov   word ptr DATA:[CONTROL.chan_time],ax ;setzen
	     jmp   @@dcd_check		    ;bei DCD weitermachen
@@is_duplex: mov   byte ptr DATA:[CONTROL.l1_state],ZUST_FREE ;Kanal ist frei
	     mov   byte ptr [Control.ch_free],TRUE ;Kanal ist frei
	     jmp   @@no_dcd		    ;ohne DCD Check weiter

@@new_frame: mov   byte ptr es:[si.txed],1  ;Frame wurde gesendet
	     mov   dx,ds		    ;DS retten
	     assume ds:nothing		    ;Ds ist ungltig
	     lds   di,dword ptr es:[si.pbEnabled] ;Zeiger holen
	     mov   ax,ds		    ;Test auf
	     or    ax,di		    ;nil
	     jz    short @@pb_no	    ;egal
             _cli
	     mov   word ptr ds:[di],offset CONTROL.ch_free ;Offset auf Variable
	     mov   word ptr ds:[di+2],dx    ;Datensegment ist Ziel
	     _sti
@@pb_no:     mov   ds,dx		    ;ds zurck
	     assume ds:data		    ;ds wieder gltig (Pascal)
	     mov   ax,word ptr es:[si.next] ;Offset nchstes Frame
	     mov   word ptr DATA:[CONTROL.txqueue.hd],ax ;setzen
	     mov   ax,word ptr es:[si.next+2] ;Segment nchstes Frame
	     mov   word ptr DATA:[CONTROL.txqueue.hd+2],ax ;setzen
	     mov   word ptr es:[si.next],0  ;Offset neu ist 0
	     mov   word ptr es:[si.next+2],0;Segment
	     ;* Element ist ausgehngt
	     test  byte ptr es:[si.discard],1 ;darf das Paket weg ??
	     jz    short @@txfirst	     ;nein
	     mov   ax,word ptr DATA:[stfl.hd]  ;Offset Listenbeginn
	     or    ax,word ptr DATA:[stfl.hd+2];Segment Nulltest
	     jnz   short @@not_txfirst	       ;es ist noch was drin
	     mov   word ptr DATA:[stfl.hd],si;Offset Listenbeginn
	     mov   word ptr DATA:[stfl.hd+2],es;Segment Listenbeginn
	     mov   word ptr DATA:[stfl.tl],si;Offset Listenende
	     mov   word ptr DATA:[stfl.tl+2],es;Segment Listenende
	     jmp   short @@txfirst	      ;weitermachen
@@not_txfirst:
	     mov   dx,ds		      ;Segment merken
	     lds   di,DATA:[stfl.tl];Zeiger auf letztes Element
	     assume ds:nothing
	     mov   word ptr ds:[di.next],si   ;Offset in altes Element
	     mov   word ptr ds:[di.next+2],es ;Segment in altes Element
	     mov   ds,dx		      ;DATA zurck
	     assume ds:DATA
	     mov   word ptr DATA:[stfl.tl+0],si;Offset neues Ende
	     mov   word ptr DATA:[stfl.tl+2],es;Segment neues Ende
@@txfirst:   ;das alte Element ist ausgehngt, das neue steht in tx_root
@@nicht_weg: les   si,dword ptr [CONTROL.txqueue.hd] ;neuen Zeiger holen
	     mov   ax,es		    ;Segment fr
	     or    ax,si		    ;Nulltest
	     jnz   short @@new_frame1	    ;ist taschlich noch eins da
	     mov   ax,4 		    ;Txtail Bytes
if NEUER eq 1
   	     LOCK
endif
if (CHAN and 1) eq 0
	     out   [DMA+TDCRA0],ax	    ;Kanal A
else
	     out   [DMA+TDCRB0],ax	    ;Kanal B
endif
             mov   al,0C0h                  ;Reset
             out   [SDLC+WR0],al            ;EOM Latch
             mov   al,19h + 02h             ;Sendeinterrupt
             out   [SDLC+WR1],al            ;freigeben
             jmp   short @@dcd_check        ;und weiter
@@new_frame1:mov   ax,word ptr es:[si.bufl+0];untere 16 Bit
if (CHAN and 1) eq 0
	     out   [DMA+TDARA0],ax	    ;Low Word der Adresse ausgeben
else
	     out   [DMA+TDARB0],ax	    ;Low Word der Adresse ausgeben
endif
	     mov   al,byte ptr es:[si.bufl+2];obere 8 Bit
if (CHAN and 1) eq 0
	     out   [DMA+TDARA0+2],al	    ;High Byte der Adresse ausgeben
else
	     out   [DMA+TDARB0+2],al	    ;High Byte der Adresse ausgeben
endif
	     mov   ax,word ptr es:[si.inUse] ;Anzahl holen
if (CHAN and 1) eq 0
	     out   [DMA+TDCRA0],ax	    ;Anzahl ausgeben
	     mov   al,0C0h		    ;Enable TX-A DMA
else
	     out   [DMA+TDCRB0],ax	    ;Anzahl ausgeben
	     mov   al,080h		    ;Enable TX-B DMA
endif
             mov   al,0C0h                  ;Reset
             out   [SDLC+WR0],al            ;EOM Latch
             mov   al,19h + 02h             ;Sendeinterrupt
             out   [SDLC+WR1],al            ;freigeben
;	     hier Test auf DCD Change Bit 3
@@dcd_check:
	     test  bh,08h		    ;DCD Change ?
	     jz    short @@no_dcd	    ;nein
	     test  bl,08h		    ;An oder Aus ??
	     jz    short @@dcd_off	    ;ist aus
;	     Wenn im Halbduplexmode und Zustand < ZUST_TXD,
;	     dann WAIT_DCD setzen und Timer = 0
;	     Sonst nix tun
	     cmp   byte ptr DATA:[CONTROL.duplex],DUP_MODE ;Vollduplex ??
	     je    short @@no_dcd	    ;ja, Zustand egal
	     cmp   byte ptr DATA:[CONTROL.l1_state],ZUST_TXD ;Senden wir ??
	     jae   short @@no_dcd	    ;ja, nichts tun
	     mov   byte ptr DATA:[CONTROL.l1_state],ZUST_DCD ;erneut mit Senden warten
	     mov   byte ptr [Control.ch_free],FALSE ;Kanal ist belegt
	     mov   byte ptr DATA:[CONTROL.chan_time],0 ;Reset Timer
	     jmp   short @@no_dcd	    ;und weiter

@@dcd_off:   cmp   byte ptr DATA:[CONTROL.duplex],DUP_MODE ;Vollduplex ??
	     je    short @@no_dcd	    ;ja Zustand egal
	     cmp   byte ptr DATA:[CONTROL.l1_state],ZUST_DCD ;warten wir auf DCD Abfall ?
	     jne   short @@no_dcd	    ;nein nix los
	     mov   byte ptr DATA:[CONTROL.l1_state],ZUST_DWAIT ;nun DWAIT abwarten
	     mov   byte ptr [Control.ch_free],TRUE ;Kanal ist frei
	     mov   ax,word ptr DATA:[CONTROL.slot] ;Slottinme holen
	     mov   word ptr DATA:[CONTROL.chan_time],ax ;Timer dann neu setzen

@@no_dcd:    test  bh,80h		    ;Abort ??
	     jz    short @@cts_chk	    ;nein
	     xor   ax,ax		    ;Empfangs-DMA
if (CHAN and 1) eq 0
	     out   [DMA+RDCRA0],ax	    ;abbrechen
else
	     out   [DMA+RDCRB0],ax	    ;abbrechen
endif
	     in    al,[DMA+DSR] 	    ;Status DMA leeren
	     cmp   byte ptr DATA:[CONTROL.l1_state],ZUST_TXD ;Senden wir ??
	     jb    short @@no_send	    ;nein
	     cmp   byte ptr DATA:[CONTROL.duplex],DUP_MODE ;Vollduplex ??
	     je    short @@no_send	    ;ja normal weiter
	     jmp   short @@ext_ex	    ;sofort Ende
@@no_send:   mov   ax,word ptr DATA:[CONTROL.rxadr_low] ;untere 16 Bit Adresse
if (CHAN and 1) eq 0
	     out   [DMA+RDARA0],ax	    ;Low Word Anfang -> DMA
else
	     out   [DMA+RDARB0],ax	    ;Low Word Anfang -> DMA
endif
	     mov   al,byte ptr DATA:[CONTROL.rxadr_hi] ;obere 4 Bit Adresse
if (CHAN and 1) eq 0
	     out   [DMA+RDARA0+2],al	    ;Low Word Anfang -> DMA
else
	     out   [DMA+RDARB0+2],al	    ;Low Word Anfang -> DMA
endif
	     mov   ax,L2MFLEN+3 	    ;DMA Lnge
if (CHAN and 1) eq 0
	     out   [DMA+RDCRA0],ax	    ;ausgeben
	     mov   al,0E0h		    ;Startkommando A
else
	     out   [DMA+RDCRB0],ax	    ;ausgeben
	     mov   al,0A0h		    ;Startkommando B
endif
	     out   [DMA+CCAR],al	    ;ausgeben
@@cts_chk:   test  bl,20h		    ;CTS an ?
	     jz    short @@ext_ex	    ;nein
	     cmp   word ptr DATA:[Control.txd],0 ;CTS gesteuert ?
	     jne   short @@ext_ex	    ;nein
	     cmp   byte ptr DATA:[Control.l1_state],ZUST_TXD ;innerhalb TXD ?
	     jne   short @@ext_ex	    ;nein
	     _cli			    ;Interrupt sperren
if (CHAN and 1) eq 0
	     mov   al,0C0h		    ;Enable TX-A DMA
else
	     mov   al,080h		    ;Enable TX-B DMA
endif
	     out   [DMA+CCAR],al	    ;DMA starten
	     mov   al,0C0h		    ;Reset Underrun Latch
	     nop			    ;warten auf Transfer
	     out   [SDLC+WR0],al	    ;und Reset TX/EOF
	     mov   byte ptr DATA:[Control.l1_state],ZUST_DAT ;Daten senden
	     _sti			    ;wieder zulassen
@@ext_ex:    ;Ende des Status Interrupts
if CHAN LT 2
	     jmp   scc1_lp		    ;SCC 1
else
	     jmp   scc2_lp		    ;SCC 2
endif
	     endm

;*************************************************
;* Interrupt on Special Receive Condition	 *
;* Aufruf: SDLC Basisadresse des SCC Ports	 *
;*	   DMA	Basisadresse der DMA		 *
;*	   CONTROL Adresse des Ctr.Blk		 *
;*	   CHAN Kanalnummer 0-3 		 *
;*************************************************
spec_int     macro CHAN,CONTROL,SDLC,DMA
	     assume ds:DATA
	     cmp   byte ptr [CONTROL.duplex],DUP_MODE	;Vollduplex ??
	     je    short @@spec_err0	    ;ja nicht weiter abfragen
	     cmp   byte ptr [CONTROL.l1_state],ZUST_TXD ;Senden wir ??
	     jb    short @@spec_err0	    ;nein kein Problem
	     mov   al,30h		    ;Error Reset
	     out   [SDLC+WR0],al	    ;an ISCC
	     jmp   @@spec_ex		    ;sofortiges Ende
@@spec_err0: in    al,[SDLC+RD1]	    ;Fehlerstatus holen
	     and   al,80h+40h+20h+0Eh	    ;Test auf EOF, Overrun, CRC, Lnge
	     cmp   al,80h+06h		    ;End of Frame, kein Fehler, Lnge mod 8
	     jne   @@spec_err1		    ;Fehler aufgetrten
if (CHAN and 1) eq 0
	     in    ax,[DMA+RDCRA0]	    ;Lnge A holen
	     mov   dx,ax		    ;merken
	     xor   ax,ax		    ;lschen
	     out   [DMA+RDCRA0],ax	    ;und Ende DMA
else
	     in    ax,[DMA+RDCRB0]	    ;Lnge B holen
	     mov   dx,ax		    ;merken
	     xor   ax,ax		    ;lschen
	     out   [DMA+RDCRB0],ax	    ;und Ende DMA
endif
	     mov   al,30h		    ;Error Reset
	     out   [SDLC+WR0],al	    ;an ISCC
	     mov   ax,L2MFLEN + 3 - 2	    ;Grsse Puffer -2 wegen CRC
	     sub   ax,dx		    ;ax = Lnge des Frames
	     les   bx,dword ptr [CONTROL.rxakt] ;aktuelle Adresse holen
	     mov   word ptr es:[bx.inUse],ax ;Lnge setzen
	     mov   byte ptr es:[bx.ifnr],CHAN+1 ;Portnummer ebenfalls
	     _cli
	     mov   ax,word ptr [fasttick+0] ;Low word Zeit
	     mov   word ptr es:[bx.time+0],ax;setzen
	     mov   ax,word ptr [fasttick+2] ;High word Zeit
	     mov   word ptr es:[bx.time+2],ax;ebenfalls
	     _sti
	     mov   word ptr es:[bx.next],0  ;Null Pointer
	     mov   word ptr es:[bx.next+2],0;als nchstes Element
	     _cli			    ;unbedingt ohne Interrupts
	     mov   dx,es		    ;Segment in dx merken
	     les   si,dword ptr DATA:[freel.hd];Anfang Freiliste holen
	     mov   ax,es		    ;Auf NIL
	     or    ax,si		    ;testen
	     jz    short @@spec_err2i       ;Liste ist leider leer

             mov   ax,word ptr DATA:[nFreeBuffer]
             dec   ax
             mov   word ptr DATA:[nFreeBuffer],ax
             cmp   ax,word ptr DATA:[nMinFreeBuffer]
             jnc   short @@noNewRecord
             mov   word ptr DATA:[nMinFreeBuffer],ax

@@noNewRecord:
	     mov   ax,word ptr es:[si.next] ;Offset Folgeelemnet
	     mov   word ptr DATA:[freel.hd],ax;setzen
	     mov   ax,word ptr es:[si.next+2];Segment Folgeelemnet
	     mov   word ptr DATA:[freel.hd+2],ax;setzen
	     ;neues Element ist ausgehngt
	     mov   word ptr DATA:[CONTROL.rxakt],si;neuer Offset
	     mov   word ptr DATA:[CONTROL.rxakt+2],es;neues Segment
	     ;Element in rxakt gemerkt
	     ;Longadresse berechnen
	     mov   al,byte ptr es:[si.bufl+2];obere 4 Bit
	     mov   byte ptr DATA:[CONTROL.rxadr_hi],al
if (CHAN and 1) eq 0
	     out   [DMA+RDARA0+2],al	    ;Low Word Anfang -> DMA
else
	     out   [DMA+RDARB0+2],al	    ;Low Word Anfang -> DMA
endif
	     mov   ax,word ptr es:[si.bufl+0];untere 16 Bit
	     mov   word ptr DATA:[CONTROL.rxadr_low],ax
if (CHAN and 1) eq 0
	     out   [DMA+RDARA0],ax	    ;Low Word Anfang -> DMA
else
	     out   [DMA+RDARB0],ax	    ;Low Word Anfang -> DMA
endif
	     in    al,[DMA+DSR] 	    ;Status DMA leeren
	     mov   ax,L2MFLEN+3 	    ;DMA Lnge
if (CHAN and 1) eq 0
	     out   [DMA+RDCRA0],ax	    ;ausgeben
	     mov   al,0E0h		    ;Startkommando A
else
	     out   [DMA+RDCRB0],ax	    ;ausgeben
	     mov   al,0A0h		    ;Startkommando B
endif
	     out   [DMA+CCAR],al	    ;ausgeben
	     ;das empfangene Frame steht noch in dx:bx (0 terminated !)
	     ;jetzt einhngen, HDLC ist ja wieder in Betrieb
	     les   si,dword ptr DATA:[rxfl.hd];Anfang Liste lesen
	     mov   ax,es		    ;Test auf
	     or    ax,si		    ;NIL
	     jnz   short @@rx_noempty	    ;Liste nicht leer
	     mov   word ptr DATA:[rxfl.hd+0],bx;Offset setzen
	     mov   word ptr DATA:[rxfl.hd+2],dx;Segment auch
	     jmp   short @@rx_empty	    ;ist leer
@@rx_noempty:les   si,dword ptr DATA:[rxfl.tl];Ende Liste lesen
	     mov   word ptr es:[si.next+0],bx;Fortsetzung Offset
	     mov   word ptr es:[si.next+2],dx;Fortsetzung Segment
@@rx_empty:  mov   word ptr DATA:[rxfl.tl+0],bx;Offset setzen
	     mov   word ptr DATA:[rxfl.tl+2],dx;Segment auch
	     _sti			    ;jetzt knnen wieder Ints
	     jmp   short @@spec_ex	    ;Ende
@@spec_err1: test  al,80h		    ;Empfangsfehler ??
	     jnz   short @@spec_err2	    ;ja
	     mov   al,30h		    ;Error Reset
	     out   [SDLC+WR0],al	    ;an ISCC
	     jmp   short @@spec_ex	    ;und Ende

@@spec_err2i: _sti			    ;weitere Interrupts zulassen
             Inc   Word Ptr DATA:[nNoBuffer]; Fehlerzhler
@@spec_err2:       			    ;
if (CHAN and 1) eq 0
	     xor   ax,ax		    ;lschen
	     out   [DMA+RDCRA0],ax	    ;und Ende DMA
else
	     xor   ax,ax		    ;lschen
	     out   [DMA+RDCRB0],ax	    ;und Ende DMA
endif
	     mov   al,30h		    ;Error Reset
	     out   [SDLC+WR0],al	    ;an ISCC
	     ;_sti			    ;Interrupts wieder erlauben
	     cmp   byte ptr [CONTROL.l1_state],ZUST_TXD ;sind wir am Senden ??
	     jb    short @@spec_err3	    ;nein kein Problem
	     cmp   byte ptr [CONTROL.duplex],DUP_MODE ;Vollduplex ?
	     jne   short @@spec_ex	    ;kein DMA Init
	     in    al,[SDLC+RD8]	    ;gepufferte Zeichen weg
	     in    al,[DMA+DSR] 	    ;Status DMA leeren
@@spec_err3: mov   ax,word ptr DATA:[CONTROL.rxadr_low] ;untere 16 Bit Adresse
if (CHAN and 1) eq 0
	     out   [DMA+RDARA0],ax	    ;Low Word Anfang -> DMA
else
	     out   [DMA+RDARB0],ax	    ;Low Word Anfang -> DMA
endif
	     mov   al,byte ptr DATA:[CONTROL.rxadr_hi] ;obere 4 Bit Adresse
if (CHAN and 1) eq 0
	     out   [DMA+RDARA0+2],al	    ;Low Word Anfang -> DMA
else
	     out   [DMA+RDARB0+2],al	    ;Low Word Anfang -> DMA
endif
	     mov   ax,L2MFLEN+3 	    ;DMA Lnge
if (CHAN and 1) eq 0
	     out   [DMA+RDCRA0],ax	    ;ausgeben
	     mov   al,0E0h		    ;Startkommando A
else
	     out   [DMA+RDCRB0],ax	    ;ausgeben
	     mov   al,0A0h		    ;Startkommando B
endif
	     out   [DMA+CCAR],al	    ;ausgeben
@@spec_ex:   ;Ende des Special Interrupts
if CHAN LT 2
	     jmp   scc1_lp		    ;SCC 1
else
	     jmp   scc2_lp		    ;SCC 2
endif
	     endm

;*************************************************
;* Sende-Interrupt (nur fr End-of-Frame)        *
;* Aufruf: SDLC Basisadresse des SCC Ports       *
;*         DMA  Basisadresse der DMA             *
;*         DMA_CMD DMA-Starkommando              *
;*         CHAN Kanalnummer                      *
;*************************************************
tx_int       macro    CHAN,SDLC,DMA,DMA_CMD
             mov      al,19h                ;Sendeinterrupt
             out      [SDLC+WR1],al         ;wieder aus
             mov      al,DMA_CMD            ;Startkommando
             _cli                           ;ohne Interrupts
             out      [DMA+CCAR],al         ;ausgeben
             mov      al,0C0h               ;Reset EOF-Flag
             out      [SDLC+WR0],al         ;an SCC
             _sti                           ;Interrupt wieder freigeben
  if CHAN LT 2
             jmp      short scc1_lp         ;SCC 1
  else
             jmp      short scc2_lp         ;SCC 2
  endif
             endm

;**********************************
;* Timerroutine fr die SCC-Ports *
;* Wird alle 10 ms aufgerufen.	  *
;**********************************
scc_timer    proc
	     assume ds:DATA,es:nothing
	     portena
	     timefunk 0,l2_parms0,SDLC1,DMA1
	     timefunk 1,l2_parms1,SDLC2,DMA1
	     timefunk 2,l2_parms2,SDLC3,DMA2
	     timefunk 3,l2_parms3,SDLC4,DMA2
	     portdis
	     ret			    ;Ende
	     assume ds:nothing,es:nothing
scc_timer    endp

ext_int0:    ext_int  0,l2_parms0,SDLC1,DMA1
ext_int1:    ext_int  1,l2_parms1,SDLC2,DMA1
ext_int2:    ext_int  2,l2_parms2,SDLC3,DMA2
ext_int3:    ext_int  3,l2_parms3,SDLC4,DMA2

spec_int0:   spec_int  0,l2_parms0,SDLC1,DMA1
spec_int1:   spec_int  1,l2_parms1,SDLC2,DMA1
spec_int2:   spec_int  2,l2_parms2,SDLC3,DMA2
spec_int3:   spec_int  3,l2_parms3,SDLC4,DMA2

tx_int0:     tx_int    0,SDLC1,DMA1,0C0h
tx_int1:     tx_int    1,SDLC2,DMA1,080h
tx_int2:     tx_int    2,SDLC3,DMA2,0C0h
tx_int3:     tx_int    3,SDLC4,DMA2,080h

rx_int0      label near
rx_int1      label near
rx_int2      label near
rx_int3      label near
	     retrbi

;************************************************************************
;* Interrupteintrittsfunktionen der V25 Version, die nicht vektorisiert *
;* arbeitet.								*
;************************************************************************
scc1_tab     label word
	     dw    offset tx_int1	    ;Sendeinterrupt Kanal 2
	     dw    offset ext_int1	    ;External Condition Kanal 2
	     dw    offset rx_int1	    ;Empfangsinterrupt Kanal 2
	     dw    offset spec_int1	    ;Special Receive Kanal 2
	     dw    offset tx_int0	    ;Sendeinterrupt Kanal 1
	     dw    offset ext_int0	    ;External Condition Kanal 1
	     dw    offset rx_int0	    ;Empfangsinterrupt Kanal 1
	     dw    offset spec_int0	    ;Special Receive Kanal 1
scc2_tab     label word
	     dw    offset tx_int3	    ;Sendeinterrupt Kanal 4
	     dw    offset ext_int3	    ;External Condition Kanal 4
	     dw    offset rx_int3	    ;Empfangsinterrupt Kanal 4
	     dw    offset spec_int3	    ;Special Receive Kanal 4
	     dw    offset tx_int2	    ;Sendeinterrupt Kanal 3
	     dw    offset ext_int2	    ;External Condition Kanal 3
	     dw    offset rx_int2	    ;Empfangsinterrupt Kanal 3
	     dw    offset spec_int2	    ;Special Receive Kanal 3

;******************************************
;* Interrupt der beiden SCCs und des SCSI *
;******************************************
bnk2_int     proc   near
	     assume ds:DATA,es:V25_SEG	  ;durch Context Switch
	     portena
	     mov    al,byte ptr es:[IRQS]   ;Interruptquelle holen
	     sti			    ;weitere IRQs zulassen
	     push   es			    ;retten
	     cmp    al,18h		    ;SCC 1 ?
	     jne    short @@not_scc1	    ;nein
@@scc1_lp1:  in     al,SDLC2+RD2	    ;Read modified Int Vektor
	     and    al,0Eh		    ;16 Adressen
	     xor    ah,ah		    ;High Byte auf 0
	     mov    bx,ax		    ;in passendes Register
	     jmp    word ptr cs:scc1_tab[bx];Ansprung
scc1_lp:     in     al,SDLC1+RD3	    ;Status lesen
	     or     al,al		    ;Ende ?
	     jnz    @@scc1_lp1		    ;nein
	     pop    es			    ;wieder zurck
	     cli			    ;besser wieder verbieten
	     fint			    ;Interruptende anzeigen
	     retrbi			    ;Register Bank Return
@@not_scc1:  cmp    al,19h		    ;SCC 2 ?
	     jne    short @@not_scc2	    ;nein
@@scc2_lp1:  in     al,SDLC4+RD2	    ;Read modified Int Vektor
	     and    al,0Eh		    ;16 Adressen
	     xor    ah,ah		    ;High Byte auf 0
	     mov    bx,ax		    ;in passendes Register
	     jmp    word ptr cs:scc2_tab[bx];Ansprung
scc2_lp:     in     al,SDLC3+RD3	    ;Status lesen
	     or     al,al		    ;Ende ?
	     jnz    @@scc2_lp1		    ;nein
	     pop    es			    ;wieder zurck
	     cli			    ;besser wieder verbieten
	     fint			    ;Interruptende anzeigen
	     retrbi			    ;Register Bank Return
@@not_scc2:  cmp    al,1Ah		    ;SCSI ?
	     jne    short @@not_scsi	    ;nein

	     pop    es			    ;wieder zurck
	     cli			    ;besser wieder verbieten
	     fint			    ;Interruptende anzeigen
	     retrbi			    ;Register Bank Return
@@not_scsi:  portdis
	     pop    es			    ;wieder zurck
	     cli			    ;besser wieder verbieten
	     fint			    ;Interruptende anzeigen
	     retrbi			    ;Register Bank Return
	     assume ds:nothing,es:nothing
bnk2_int     endp

;*******************************************
;* Initialisierungstabelle einmaliges Init *
;*******************************************
first_tab1   label  word
	     dw     SDLC1+WR9		    ;Register 9 SCC1
	     db     0C1h		    ;Master Reset SCC, modify Vektor
	     dw     SDLC1+WR2		    ;Vektor Register
	     db     0			    ;Tabellenwert
	     dw     SDLC1+WR9		    ;Register 9 SCC1
	     db     09h 		    ;MIE und VIS ein
	     dw     DMA1+CCAR		    ;Kommandoregister DMA
	     db     060h		    ;Reset DMA
	     dw     DMA1+DCR		    ;DMA Control Register
	     db     8Fh 		    ;normale Prioritt, Increment
	     dw     DMA1+ICR		    ;Interrupt Control Register
	     db     10h 		    ;Interrupts aus, Status ein
	     dw     SDLC3+WR9		    ;Register 9 SCC1
	     db     0C1h		    ;Master Reset SCC, modify Vektor
	     dw     SDLC3+WR2		    ;Vektor Register
	     db     0			    ;Tabellenwert
	     dw     SDLC3+WR9		    ;Register 9 SCC2
	     db     09h 		    ;MIE und VIS ein
	     dw     DMA2+CCAR		    ;Kommandoregister DMA
	     db     060h		    ;Reset DMA
	     dw     DMA2+DCR		    ;DMA Control Register
	     db     8Fh 		    ;normale Prioritt, Increment
	     dw     DMA2+ICR		    ;Interrupt Control Register
	     db     10h 		    ;Interrupts aus, Status ein
	     dw     0FFFFh		    ;Ende der Tabelle

scc_first    proc
	     arg    struclen:word	    ;Lnge der L1-Struktur
	     assume ds:DATA
	     mov    bx,offset DATA:l2_parmse;Ende der L1-Struktur
	     sub    bx,offset DATA:l2_parms;- Anfang
	     mov    ax,FALSE		    ;falls Fehler
	     cmp    bx,[struclen]	    ;gleich ?
	     jne    @@first_err 	    ;nein Fehler
	     mov    cx,4		    ;Anzahl Ports
	     mov    si,offset DATA:l2_parms0;Anfang der Struktur
	     xor    ax,ax		    ;ax = 0
@@first_lp:  mov    word ptr DATA:[si.rxakt],ax
	     mov    word ptr DATA:[si.rxakt+2],ax
	     mov    word ptr DATA:[si.txqueue.hd],ax
	     mov    word ptr DATA:[si.txqueue.hd+2],ax
	     mov    word ptr DATA:[stfl.hd],ax
	     mov    word ptr DATA:[stfl.hd+2],ax
	     mov    word ptr DATA:[si.chan_time],ax
	     mov    byte ptr DATA:[si.l1_state],ZUST_NOP
	     mov    byte ptr DATA:[si.wr5_rx],al
	     mov    byte ptr DATA:[si.wr5_tx],al
	     mov    byte ptr DATA:[si.ch_free],FALSE ;Kanal ist "belegt"
	     add    si,size sccdef	    ;einen Eintrag weiter
	     loop   @@first_lp		    ;ber alle Ports
	     portena			    ;IO-Ports freigeben
	     mov   si,offset first_tab1     ;Zeiger auf Port Init Tabelle
@@first1:    mov   dx,word ptr cs:[si]	    ;Portadresse holen
	     cmp   dx,0FFFFh		    ;Ende ?
	     je    short @@first2	    ;ja
	     mov   al,byte ptr cs:[si+2]    ;Ausgabewert
	     out   dx,al		    ;an Port
	     add   si,3 		    ;Zeiger auf nchsten Eintrag
	     jmp   short @@first1	    ;und weiter
@@first2:    pushf			    ;temporr sperren
	     cli			    ;jetzt nicht
	     mov   ax,V25_SEG		    ;Segment V25 IO
	     mov   es,ax		    ;setzen
	     assume es:V25_SEG
	     or    byte ptr es:[PRC],40h    ;internes RAM ein
	     mov   word ptr es:[bnk2.cs_reg],cs ;Codesegment setzen
	     mov   word ptr es:[bnk2.pc_vektpr],offset bnk2_int ;Offset dazu
	     mov   word ptr es:[bnk2.ds_reg],DATA ;Zeiger auf Datensegment
	     mov   word ptr es:[bnk2.es_reg],V25_SEG;V25-IO-Segment
	     mov   word ptr es:[bnk2.ss_reg],DATA ;Stack ist im Datensegment
	     mov   word ptr es:[bnk2.sp_reg],offset DATA:bnk2_stkend-2 ;Ende des Stacks
	     mov   al,12h		    ;Bank Switch Interrupt 2
	     mov   byte ptr es:[EXIC0],al   ;Interrupt freigeben
	     mov   al,17h		    ;Bank Switch Interrupt 2
	     mov   byte ptr es:[EXIC1],al   ;Interrupt freigeben
	     popf			    ;alter Interrupt Zustand
	     portdis			    ;IO-Port Zugriffe sperren
	     mov   ax,TRUE		    ;kein Fehler
@@first_err: ret
	     assume ds:nothing,es:nothing
scc_first    endp

	     end
